# CJustify()

Returns the given string justified to the center, padding out the words with spaces accordingly

```
CJustify( string=string, length=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | May be empty. If it is a variable that is defined as a number, the function processes it as a string. |  |
| length | number | Yes | A positive integer. Length of field. |  |

# Examples

```cfml
	string = "A light-weight dynamic scripting language for the JVM.";
	dump(cJustify(string, 5));

	// member function
	dump(string.cJustify(5));

    s = "";
    res = cJustify(s, 4);
    writeDump(len(res)); // length is 4
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "abc";
    res = cJustify(s, 10);
    writeDump(len(res)); // length is 10
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "10";
    res = cJustify(s, 8);
    writeDump(len(res)); // length is 8
    writeoutput("<pre>|#res#|</pre>");

```







# Categories

[Strings](../../categories/string.md), [Formatting](../../categories/formatting.md)

# See Also

[string.cJustify()](../objects/string/cjustify.md)