# Canonicalize()

Canonicalization is simply the operation of reducing a potentially encoded, query string down to its simplest form.

This is important, because attackers frequently use encoding to change their input in a way that will bypass validation filters,
but still be interpreted properly by the target of the attack.

Note that data encoded more than once is not something that a normal user would generate and should be regarded as an attack.

**Requires Extension:** [ESAPI extension](https://download.lucee.org/#37C61C0A-5D7E-4256-8572639BE0CF5838)

```
Canonicalize( input=string, restrictMultiple=boolean, restrictMixed=boolean, throwOnError=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| input | string | Yes | the input string to encode *Alias: inputString* |  |
| restrictMultiple | boolean | Yes | true if checking for multiple encoding is desired, false otherwise. *Alias: multiple* |  |
| restrictMixed | boolean | Yes | true if checking for mixed encoding is desired, false otherwise *Alias: mixed* |  |
| throwOnError | boolean | No | If the value of this argument is true, and if restrictMultiple or restrictMixed is true and the given input contains mixed or multiple encoded strings, an exception will be thrown. If the value of this argument is false, an empty string will be returned instead of an exception. *Alias: error* | false |

# Examples

```cfml
plain = "&lt;";
plain_bad = "%26lt; %26lt; %2526lt%253B %2526lt%253B %2526lt%253B";

dump(Canonicalize(plain,true,true));

// checking for malicious string
try {
   dump(Canonicalize(plain_bad,true,true).LogMessage);
} catch (Any e) {
   dump(var = e.LogMessage, label = "exception message");
}
```







# Categories

[Encode/Decode](../../categories/esapi.md), [Parsing](../../categories/parsing.md), [Internet Protocols](../../categories/protocols.md)