# CallStackGet()

Returns the context (stacktrace) of the current position.

```
CallStackGet( type=string, offset=number, maxFrames=number );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| type | string | No | the type of the returned value, possible values are: - array - string - html - json | array |
| offset | number | No | the number of frames to skip, default is 0 | 0 |
| maxFrames | number | No | the maximum number of frames to return, default is 0 which means all | 0 |

# Examples

```cfml
dump(var=CallStackGet(type="json"), label="json ");
dump(var=CallStackGet(type="json", offset=2), label="json with offset");
dump(var=CallStackGet(type="json", maxframes=2), label="json with maxFrames");

dump(var=CallStackGet("string"), label="string");
dump(var=CallStackGet("array"), label="array");
dump(var=CallStackGet("html"), label="html");
```







# Categories

[Debugging](../../categories/debugging.md)

# See Also

[CallStackDump()](callstackdump.md)