# CachePut()

Stores an object in the cache, with a life time and an idle time.

```
CachePut( id=string, value=object, timeSpan=timespan, idleTime=timespan, cacheName=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| id | string | Yes | The id for the cache object. *Alias: key, name* |  |
| value | object | Yes | The value of the object. |  |
| timeSpan | timespan | No | The interval until the object is flushed from the cache, as a decimal number of days. One way to set the value is to use the return value from the CreateTimeSpan function. The default is to not time out the object. |  |
| idleTime | timespan | No | A decimal number of days after which the object is flushed from the cache if it is not accessed during that time. One way to set the value is to use the return value from the CreateTimeSpan function. |  |
| cacheName | string | No | definition of the cache used by name, when not set the "default Object Cache" defined in Lucee Administrator is used instead. *Alias: cache, region* |  |

# Examples

```cfml
<cfset cacheput_obj = now()>
<cfset cachePut('cacheput_obj',cacheput_obj,createTimespan(0,0,0,30),createTimespan(0,0,0,30),'region_cachename')>
//In above region_cachename is, should be creates a cache from lucee_administrator
<cfoutput>Cache Exists is <b>#cacheIdExists('cacheput_obj','test_cache')#</b></cfoutput>

```







# Categories

[Cache](../../categories/cache.md)