# CacheIdExists()

Returns true/false whether the cache contains an element with the certain id.

```
CacheIdExists( id=string, cacheName=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| id | string | Yes | key to check *Alias: name, key* |  |
| cacheName | string | No | definition of the cache used by name, when not set the "default Object Cache" defined in Lucee Administrator is used instead. *Alias: cache, region* |  |

# Examples

```cfml
<cfset cache_obj = 'fruits'>
<cfset cachePut('cache_obj',cache_obj,createTimespan(0,0,0,30),createTimespan(0,0,0,30),'region_cachename')>
//In above region_cachename is, should be creates a cache from lucee_administrator.
<cfoutput>Cache Exists is <b>#cacheIdExists('cache_obj','test_cache')#</b></cfoutput>
```







# Categories

[Cache](../../categories/cache.md)