# CacheGet()

Gets an object that is stored in the cache.

```
CacheGet( id=string, throwWhenNotExist=object, cacheName=string );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| id | string | Yes | name of the element to return *Alias: name, key* |  |
| throwWhenNotExist | object | No | define if the functions throws an exception when the element does not exist. Default is false. | false |
| cacheName | string | No | definition of the cache used by name, when not set the "default Object Cache" defined in Lucee Administrator is used instead. *Alias: cache, region* |  |

# Examples

```cfml
  cachePut(id:'abc', value:'123',timeSpan:CreateTimeSpan(0,0,0,1),cacheName:'fruits');
  getcache = cacheGet(id:'abc',cacheName:'fruits');
  writeDump(getcache);
```







# Categories

[Cache](../../categories/cache.md)