# BitMaskRead()

Performs a bitwise mask read operation.

Returns an integer, created from length bits of number, beginning at start.

```
BitMaskRead( number=number, start=number, length=number );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | number | Yes | an integer to mask |  |
| start | number | Yes | Integer, in the range 0-31, inclusive; start bit for read |  |
| length | number | Yes | Integer, in the range 0-31, inclusive; length of mask |  |

# Examples

The following code example will output an example numbers returned from the bitMaskRead() function.

```cfml
    writeOutput(bitMaskRead(255, 5, 5))
    writeOutput("<br>")
    writeOutput(bitMaskRead(255, 0, 4))
```







# Categories

[Math](../../categories/math.md), [Numbers](../../categories/number.md)

# See Also

[numeric.bitMaskRead()](../objects/numeric/bitmaskread.md)