# BinaryEncode()

Converts binary data to a string.

```
BinaryEncode( binary=binary, encoding=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| binary | binary | Yes | A variable containing the binary data to encode. *Alias: binaryData* |  |
| encoding | string | Yes | A string that specifies the encoding method to use to represent the data; one of the following: - Hex: use the characters 0-9 and A-F to represent the hexadecimal value of each byte. - UU: use the UNIX UUencode algorithm to convert the data - Base64: use the Base64 algorithm to convert the data, as specified by IETF RFC 2045, at www.ietf.org/rfc/rfc2045.txt. |  |

# Examples

```cfml
base_64 = ToBase64("I am a string.");
binary_data = ToBinary(base_64);
dump(BinaryEncode(binary_data, "hex")); // 4920616D206120737472696E672E
```







# Categories

[Binary data](../../categories/binary.md)

# See Also

[BinaryDecode()](binarydecode.md)