# BinaryDecode()

Converts a string to a binary object.

Used to convert binary data that has been encoded into string format back into binary data.

```
BinaryDecode( encoded_binary=string, binaryEncoding=string, precise=boolean );
```

**Returns:** binary

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| encoded_binary | string | Yes | A string containing encoded binary data. *Alias: encodedBinary, string, value* |  |
| binaryEncoding | string | Yes | A string specifying the algorithm used to encode the original binary data into a string; must be one of the following: - hex: characters 0-9 and A-F represent the hexadecimal value of each byte - UU: data is encoded using the UNIX UUencode algorithm - base64: data is encoded using the Base64 algorithm *Alias: encoding* |  |
| precise | boolean | No | if set to true the input must follow the rule for that encoding a 100%, the decryptor will not try to interpret inputs that are not a 100% correct. This should be used to avoid false positives. | true |

# Usage Notes

The new `precise` argument can be set to false for backwards compatibility [LDEV-4101](https://luceeserver.atlassian.net/browse/LDEV-4101)

# Examples

```cfml
base_64 = ToBase64("I am a string.");
binary_data = ToBinary(base_64);
encoded_binary = BinaryEncode(binary_data, "hex");
dump(BinaryDecode(encoded_binary, "hex"));
```







# Categories

[Binary data](../../categories/binary.md)

# See Also

[BinaryEncode()](binaryencode.md)