# astFromString()

**Parses CFML source code from a string and returns its Abstract Syntax Tree (AST) representation.**

The AST is a structured tree that represents the syntactic structure of the CFML code, making it useful for:

- **Code Analysis**: Static analysis, complexity metrics, dependency tracking
- **IDE Tooling**: Syntax highlighting, autocomplete, refactoring support  
- **Transformation**: Code generation, minification, transpilation
- **Documentation**: Automatic API documentation generation
- **Quality Assurance**: Linting, code style enforcement, security scanning

The returned AST uses **neutral, language-agnostic node types** following ESTree conventions such as `BinaryExpression`, `IfStatement`, `FunctionDeclaration`, and literal types. Each node includes **source position information** for precise error reporting and IDE integration.

**Introduced:** 7.0.0.296

```
astFromString( cfmlCode=string );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| cfmlCode | string | Yes | a string containing CFML code to be parsed into an AST structure |  |

# Examples

*There are currently no examples for this function*







# See Also

[AST (Abstract Syntax Tree)](../../recipes/ast.md), [astFromPath()](astfrompath.md)