# astFromPath()

Parses a CFML file and returns its Abstract Syntax Tree (AST) representation.

The AST is a structured tree that represents the syntactic structure of the CFML code, making it useful for:

- **Code Analysis**: Static analysis, complexity metrics, dependency tracking
- **IDE Tooling**: Syntax highlighting, autocomplete, refactoring support  
- **Transformation**: Code generation, minification, transpilation
- **Documentation**: Automatic API documentation generation
- **Quality Assurance**: Linting, code style enforcement, security scanning

The returned AST uses **neutral, language-agnostic node types** following ESTree conventions such as `BinaryExpression`, `IfStatement`, `FunctionDeclaration`, and literal types. Each node includes **source position information** (line, column, offset) for precise error reporting and IDE integration.

**Introduced:** 7.0.0.296

```
astFromPath( path=any );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| path | any | Yes | reference to a cfml template, can be a string containing a rel or absolute path, or any other kind of file (java.io.File,lucee.commons.io.res.Resource) or a file stream open with help of the function fileopen |  |

# Examples

*There are currently no examples for this function*







# See Also

[AST (Abstract Syntax Tree)](../../recipes/ast.md), [astFromString()](astfromstring.md)