# ArrayUnShift()

This method adds one or more elements to the beginning of an array and returns the new length of the array.

**Introduced:** 5.3.8.104

```
ArrayUnShift( array=array, value=any );
```

**Returns:** numeric

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array where an object is to be added. |  |
| value | any | Yes | Element to be added at the beginning of an array |  |

# Examples

```cfml
numbers = [ 1, 2, 3, 4 ];
Dump( ArrayUnShift( numbers, 0 ) ); // Outputs 5

moreNumbers = [ 5, 6, 7, 8 ];
Dump( ArrayUnShift( moreNumbers, 4 ) ); // Outputs 5

```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.unshift()](../objects/array/unshift.md)