# ArrayToStruct()

Transform the array to a struct, the index of the array is the key of the struct

```
ArrayToStruct( array=array, valueAsKey=boolean );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | array to translate |  |
| valueAsKey | boolean | No | use the value as the key of the struct, rather than the index | false |

# Examples

### Simple Array

```cfml
arr = ['a','b','c','d','e','f','g'];
dump(arrayToStruct(arr));
if (listFirst(server.lucee.version,".") gte 6)
    dump(arrayToStruct(arr, true));

//member function
dump(arr.toStruct());
```

### Array of Structs

```cfml
arr = [
    {name:'a'},
    {name:'b'},
    {name:'c'},
    {name:'d'},
    {name:'e'}
];
dump(arrayToStruct(arr));

//member function
dump(arr.toStruct());
```







# Categories

[Arrays](../../categories/array.md), [Structures](../../categories/struct.md)

# See Also

[array.toStruct()](../objects/array/tostruct.md)