# ArraySort()

Sorts array elements numerically or alphanumerically.

```
ArraySort( array=object, sortType_or_closure=object, sort_order=string, locale_sensitive=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | object | Yes | Name of an array |  |
| sortType_or_closure | object | No | value can be a string or a closure/function. a string must be one of the following values: - "numeric": sorts numbers - "text": sorts text alphabetically, taking case into account (case sensitive) - "textnocase": sorts text alphabetically, without regard to case (case insensitive) if you define a closure/function, the closure/function must accept 2 parameters of any type and return: - \-1, if first parameter is "smaller" than second parameter - 0, if first parameter is equal to second parameter - 1, first parameter is "bigger" than second parameter `function (any e1, any e2) { return -1/0/1;});` *Alias: sort_type, sortType, closure, function, udf, callback* | textNoCase |
| sort_order | string | No | sort direction: - asc(default): ascending sort order - desc: descending sort order. *Alias: sortOrder* | asc |
| locale_sensitive | boolean | No | if true, use locale sensitive sorting. *Alias: localeSensitive* | false |

# Examples

### Simple array using sort type and order

```cfml
SomeArray = ["COLDFUSION","coldfusion","adobe","LucEE","LUCEE"];

arraySort(SomeArray,"text","desc");
dump(SomeArray);

//member function
SomeArray.sort("text","desc");
dump(SomeArray);

SomeArray = [
    {name="testemployee", age="32"},
    {name="employeetest", age="36"}
];

arraySort(
    SomeArray,
    function (e1, e2){
        return compare(e1.name, e2.name);
    }
);
dump(SomeArray);

// member function with closure
SomeArray.sort(
    function (e1, e2){
        return compare(e1.name, e2.name);
    }
);
dump(SomeArray);
```







# Categories

[Arrays](../../categories/array.md), [Sorting](../../categories/sort.md)

# See Also

[array.sort()](../objects/array/sort.md)