# ArraySome()

This function calls a given closure/function with every element in a given array and returns true, if one of the closure calls returns true.

```
ArraySome( array=array, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | array to iterate *Alias: object* |  |
| closure | function | Yes | function/closure that implements the following constructor [function(any value[, numeric index,array array]):boolean]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

### uses a closure to determine if an item or expression exists

```cfml
	newArray = ['a','b','c','b','d','b','e','f'];
	dump(newArray);

	hasSome1 = arraySome(newArray,function(item,idx,arr){
	    return item == 'b';
	});
	dump(hasSome1);

    // member function
	hasSome2 = newArray.some(function(item,idx,arr){
	    return item == 'k';
	});
	dump(hasSome2);

```







# Categories

[Arrays](../../categories/array.md), [Collections](../../categories/collection.md)

# See Also

[array.some()](../objects/array/some.md)