# ArraySlice()

Returns a new array, from the start position up to the count of elements

```
ArraySlice( array=array, offset=number, length=number );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | array to slice |  |
| offset | number | Yes | start position in the original array to slice |  |
| length | number | No | number of elements to slice from offset |  |

# Examples

### Gets a sub section of an array and returns it

```cfml
	newArray = ['a','b','c','b','d','b','e','f'];
	dump(newArray);

	hasSome1 = arraySlice(newArray,1,4);
	dump(hasSome1);

    // member function
	hasSome2 = newArray.slice(3,6);
	dump(hasSome2);
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.slice()](../objects/array/slice.md)