# ArrayShift()

Removes the first element of an array and returns the element that is removed. This method removes the element at the first index and shifts the values at consecutive indexes down. If you use ArrayShift in an empty array, you get an exception.

**Introduced:** 5.3.8.104

```
ArrayShift( array=array, defaultValue=any );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array to shift. |  |
| defaultValue | any | No | this value is returned in case the array is empty |  |

# Examples

```cfml
numbers = [ 1, 2, 3, 4 ];
ArrayShift( numbers );
Dump( numbers ); // Outputs 1

moreNumbers = [ 5, 6, 7, 8 ];
ArrayShift( moreNumbers );
Dump( numbers ); // Outputs 5

numbers     = [ "one", "two", "three", "four" ];
ArrayShift( numbers);
Dump( numbers ); // Outputs one


```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.shift()](../objects/array/shift.md)