# ArraySet()

In an one-dimensional array, sets the elements in a specified index range to a value.

Useful for initializing an array after a call to ArrayNew.

```
ArraySet( array=array, start_pos=number, end_pos=number, value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | Name of an array. |  |
| start_pos | number | Yes | Starting index position of range to set. *Alias: start, startPos* |  |
| end_pos | number | Yes | Ending index position of range to set. If this value is greater than array length, Lucee adds elements to array. *Alias: end, endPos* |  |
| value | any | Yes | Value to which to set each element in the range. |  |

# Examples

### Sets a range of array positions to a value

```cfml
	newArray = arrayNew(1);

	arraySet(newArray, 1, 4, "All is well");
	dump(newArray);

    // member function
	newArray.set(1,2,"lets change it");
	dump(newArray);

```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.set()](../objects/array/set.md)