# ArrayResize()

Resets an array to a specified minimum number of elements.

This can improve performance, if used to size an array to its expected maximum.

For more than 500 elements, use ArrayResize immediately after using the ArrayNew tag.

```
ArrayResize( array=array, minimum_size=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | Name of an array |  |
| minimum_size | number | Yes | minimum size of the array *Alias: minimum, size* |  |

# Examples

### Sets a minimum number of array items for an array

Fills the unset array items with null

```cfml
numbers = [ 1, 2, 3, 4 ];

arrayResize(numbers,10);
Dump( numbers );

//member function
numbers.resize(15);
Dump( numbers );
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.resize()](../objects/array/resize.md)