# ArrayReduce()

Iterates over every entry of the given array and calls the closure with every element.
This function will reduce the array to a single value and will return the value.

```
ArrayReduce( array=array, closure=function, initialValue=object );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | array to iterate *Alias: object* |  |
| closure | function | Yes | function/closure that implements the following constructor `function(any result, object value, [, numeric index [, array]]){ return result; }` *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |

# Examples

```cfml
reduced = ArrayReduce( [1,2,3,4], function( carry, value ){
    return carry + value;
}, 0 );
dump( reduced ); // yields 10

reduced = ArrayReduce( ['hello', 'there', 'lucee'], function(carry, value){
    return carry & ' ' & value;
}, '' );
dump( reduced ); // yields 'hello there lucee'
```







# Categories

[Arrays](../../categories/array.md), [Collections](../../categories/collection.md), [Threads](../../categories/thread.md)

# See Also

[array.reduce()](../objects/array/reduce.md), [Complete Guide to Threading in Lucee](../../recipes/thread-usage.md)