# ArrayPush()

Adds an element at the end of an array and returns a new size of the array.

**Introduced:** 5.3.8.104

```
ArrayPush( array=array, value=any );
```

**Returns:** numeric

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array where an value/object is to be added. |  |
| value | any | Yes | Element to be added at the end of an array |  |

# Examples

```cfml
numbers = [ 1, 2, 3, 4 ];
Dump( ArrayPush( numbers, 0 ) ); // Outputs 5

moreNumbers = [ 5, 6, 7, 8 ];
Dump( ArrayPush( moreNumbers, 4 ) ); // Outputs 5

```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.push()](../objects/array/push.md)