# ArrayPrepend()

Inserts an array element at the beginning of an array
and shifts the positions of the existing elements to
make room.

```
ArrayPrepend( array=array, value=any, merge=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | Name of an array |  |
| value | any | Yes | value to prepend |  |
| merge | boolean | No | This argument only applies when the value is an array. If set to true prepend array elements individually to the source array. If false (default) the complete array is added as one element at the top, in the source array. |  |

# Examples

### Add an array item on to the front of an array

```cfml
someArray = [3,2,1];
arrayPrepend(someArray, 4);
dump(someArray);

// member function
doctorWhoArray = ['Whittaker','Tennant','Baker'];
doctorWhoArray.prepend('Hurt');
dump(doctorWhoArray);
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.prepend()](../objects/array/prepend.md)