# ArrayPop()

Removes the last element of an array.

In case the array is empty an exception is thrown, unless the second argument "defaultValue" is provided, in that case that value is returned.

**Introduced:** 5.3.8.104

```
ArrayPop( array=array, defaultValue=any );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array whose last element is to be removed. |  |
| defaultValue | any | No | this value is returned in case the array is empty |  |

# Examples

```cfml
numbers = [ 1, 2, 3, 4 ];
dump( ArrayPop( numbers ) ); // Outputs 4
dump( numbers ); // Outputs [ 1, 2, 3 ]

moreNumbers = [ 5, 6, 7, 8 ];
dump( ArrayPop( moreNumbers, 4 ) ); // Outputs 8
dump( moreNumbers ); // Outputs [ 5, 6, 7 ]

```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.pop()](../objects/array/pop.md)