# ArrayNew()

create a new array. Shorthand syntax is [].

```
ArrayNew( dimension=number, type=string, synchronized=boolean );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| dimension | number | No | Number of dimensions in new array: 1, 2, or 3 *Alias: dimensions* | 1 |
| type | string | No | Type of the elements that the array can store. If set, attempting to add an element that can not be cast to the specified type, will throw an exception. *Alias: typename* |  |
| synchronized | boolean | No | is the array synchronized or not (aka thread safe) *Alias: isSynchronized* | true |

# Examples

### create a new array, set the dimension

```cfml
  a = arrayNew(1);
    // Implicit array notation
    a.append([]);
    // with values
    a.append( [
        'a','b',
        3, 4,
        [],
        {complex: true},
        queryNew("id,date")
    ] );
    dump(a);
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[StructNew()](structnew.md), [Array](../objects/array.md)