# ArrayMerge()

This function creates a new array with data from the two passed arrays. To add all the data from one array into another without creating a new array see the built in function ArrayAppend(arr1, arr2, true).

```
ArrayMerge( array1=array, array2=array, leaveIndex=boolean );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array1 | array | Yes | first array |  |
| array2 | array | Yes | second array |  |
| leaveIndex | boolean | No | defines whether the merged arrays will maintain their index values or if the second array will simply append to the first one. If both arrays contain the same index and you specified the parameter leaveIndex to true, the corresponding index in the resulting array will always contain the value of the index of the first array. |  |

# Examples

### Appends one array onto another array

```cfml
aNames = array(10412,42,33,2,999,12769,888);

aNames2 = array(33,'b','c','d','e','f','g');

dump(arrayMerge(aNames,aNames2));

//member function
dump(aNames.merge(aNames2));

dump(aNames.merge(aNames2, true));

```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.merge()](../objects/array/merge.md)