# ArrayMap()

Calls the given closure with every element in the given array.

The function returns an array that contains all values returned by the closure.

```
ArrayMap( array=array, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | array to iterate |  |
| closure | function | Yes | filter can be a function/closure that implements the following constructor [function(any value[, number index, array array]):any]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

### Modify an array and store it back into the array

Does not modify existing array, creates a new array and stores it to the assigned variable

```cfml
aNames = ["Marcus","Sarah","Josefine"];
dump(aNames);

newNames1 = arrayMap(aNames,function(item,index,arr){
    return {'name':item};
});
dump(newNames1);

//member function
newNames2 = aNames.map(function(item,index,arr){
    return {'name':item};
});
dump(newNames2);
```







# Categories

[Arrays](../../categories/array.md), [Collections](../../categories/collection.md), [Threads](../../categories/thread.md)

# See Also

[array.map()](../objects/array/map.md), [Complete Guide to Threading in Lucee](../../recipes/thread-usage.md)