# ArrayInsertAt()

Inserts a value at the specified position in the array.
If the element is inserted before the end of the array, Lucee shifts the positions of all elements with a higher index to make room.

```
ArrayInsertAt( array=array, position=number, value=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array which will have the new element inserted. |  |
| position | number | Yes | The numerical index in the array where the new element will be inserted. Must be less than or equal to the length of the array. Remember CFML arrays start at 1 not 0. |  |
| value | any | Yes | value to insert |  |

# Examples

### Insert item into an array at a given position within the array length

```cfml
fruitArray = ['apple', 'kiwi', 'banana', 'orange', 'mango', 'kiwi'];

arrayInsertAt(fruitArray,3,'new inserted item');
dump(fruitArray);

// member function
fruitArray.insertAt(3,'member added item');
dump(fruitArray);
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.insertAt()](../objects/array/insertat.md)