# ArrayFindNoCase()

Performs a case-insensitive search in the array for the specified object. Returns the index of the object found, or 0 if the object was not found.

```
ArrayFindNoCase( array=array, value=any );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array to search in |  |
| value | any | Yes | The value to find *Alias: object* |  |

# Examples

```cfml
arrVariable = [ "Water", "Sky", 2, "Air" ];

WriteDump( ArrayFindNoCase( arrVariable, 5 ) ); // Outputs 0

WriteDump( ArrayFindNoCase( arrVariable, "air" ) ); // Outputs 4

WriteDump( ArrayFindNoCase( arrVariable, 2 ) ); // Outputs 3
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.findNoCase()](../objects/array/findnocase.md)