# ArrayFindAll()

These functions searches the array for the specified object and return the positions of all occurrence of this values.

```
ArrayFindAll( array=array, value_or_closure=any );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array to search in |  |
| value_or_closure | any | Yes | - The value to find - A closure/function that gets every value of the array as input and returns true if the given value is right, with the following signature: `boolean function(el){}` *Alias: object, value, closure, function, udf, callback* |  |

# Examples

### Find all the positions of all occurrences of a string in array

```cfml
fruitArray = [ 'apple', 'kiwi', 'banana', 'orange', 'mango', 'kiwi' ];

favoriteFruits = arrayFindAll( fruitArray, 'kiwi' );
dump( favoriteFruits ); // [ 2, 6 ]

notKiwis = arrayFindAll( fruitArray,
    function( el ){ 
        return arguments.el neq 'kiwi';
});
dump( notKiwis ); // [1,3,4,5]

```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.findAll()](../objects/array/findall.md)