# ArrayFind()

These functions searches the array for the specified object.

```
ArrayFind( array=array, value_or_closure=any );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array to search in |  |
| value_or_closure | any | Yes | The value to find or a closure/function that gets every value of the array as input and returns true if the given value is right. *Alias: object, value, closure, function, udf, callback* |  |

# Examples

### Find first occurrence of string in array

```cfml
fruitArray = ['apple', 'kiwi', 'banana', 'orange', 'mango', 'kiwi'];

favoriteFruits = arrayFind(fruitArray,'kiwi');
dump(favoriteFruits); //2
```







# Categories

[Arrays](../../categories/array.md), [Collections](../../categories/collection.md)

# See Also

[ArrayContains()](arraycontains.md), [array.find()](../objects/array/find.md)