# ArrayEvery()

This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.

```
ArrayEvery( array=array, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | array to iterate *Alias: object* |  |
| closure | function | Yes | function/closure that implements the following constructor [function(any value[, numeric index,array array]):boolean]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

### Loops over every element in the array

```cfml
my_array = [ { name = "Frank", age = 40 }, { name = "Sue", age = 21 }, { name = "Jose", age = 54 } ];
all_old = my_array.every(function(person) {
    return person.age >= 40;
},true,5);

dump(all_old); // false
```







# Categories

[Arrays](../../categories/array.md), [Collections](../../categories/collection.md), [Threads](../../categories/thread.md)

# See Also

[array.every()](../objects/array/every.md)