# ArrayEach()

call the given UDF/Closure with every value in the array.

```
ArrayEach( array=array, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | array to take values from |  |
| closure | function | Yes | A closure function (UDF) with the following signature: `function(el, idx, arr){}` Which is called for each item in the array. Where `el` is the element (or item) of the array, `idx` is the index position of that element, and `arr` is a reference to the base array upon which the arrayEach function is called. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

##### Basic Example

```cfml
aNames = array("Marcus", "Sarah", "Josefine");

arrayEach(
    aNames,
    function(element) {
        dump(element);
    }
);
```

##### Parallel Example with 3 Threads

```cfml
start = getTickCount();
a = ["a","b","c","d","e","f","g","h","i"];
arrayEach(
    a,
    function(element, index, array) {
        writeOutput("<code>#index#:#element# [#getTickCount()#]</code><br>");
        sleep(100);
    },
    true,
    3
);

writeOutput('Total Time: #(getTickCount()-start)# milliseconds<br>');
```







# Categories

[Arrays](../../categories/array.md), [Collections](../../categories/collection.md), [Threads](../../categories/thread.md)

# See Also

[array.each()](../objects/array/each.md), [Complete Guide to Threading in Lucee](../../recipes/thread-usage.md)