# ArrayDeleteNoCase()

Deletes specified object from given array, in case of a string the case of the string does not matter.

```
ArrayDeleteNoCase( array=array, value=object, scope=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array to delete from |  |
| value | object | Yes | The value to delete |  |
| scope | string | No | one: replaces the first occurrence (default) all: replaces all occurrences |  |

# Examples

```cfml
	arr=['lucee','SUSI'];
	writeDump(var=arr,label="Before");
	arrayDeleteNoCase(arr, 'suSi');
	writeDump(var=arr,label="After");//lucee
	arrNew=['a','Ab','c','A','a'];
	writeDump(var=arrNew,label="Before");
	arrayDeleteNoCase(arrNew, 'a',"all");
	writeDump(var=arrNew,label="After");
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.deleteNoCase()](../objects/array/deletenocase.md)