# ArrayDeleteAt()

Deletes an element from an array and resizes the array so that the deleted element doesn't leave a gap.

```
ArrayDeleteAt( array=array, position=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array that the element will be deleted from. |  |
| position | number | Yes | The numeric position of the element. Remember that CFML arrays start at 1 not 0. *Alias: index* |  |

# Examples

### Deletes an array element by its index

```cfml
arr = [12,0,1,2,3,4,5,6];
dump(arr);
arrayDeleteAt(arr,4);
dump(arr);
```

### Deletes an array element by its index (member function)

```cfml
arr = [12,0,1,2,3,4,5,6];
dump(arr);
arr.deleteAt(4);
dump(arr);
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.deleteAt()](../objects/array/deleteat.md)