# ArrayDelete()

Deletes specified object from given array

```
ArrayDelete( array=array, value=object, scope=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array to delete from |  |
| value | object | Yes | The value to delete |  |
| scope | string | No | one: replaces the first occurrence (default) all: replaces all occurrences |  |

# Examples

### Deletes an array element by its value

```cfml
arr = [12,0,1,2,3,4,5,6];
dump(arr);
arrayDelete(arr,4);
dump(arr);
```

### Deletes an array element by its value (member function)

```cfml
arr = [12,0,1,2,3,4,5,6];
dump(arr);
arr.delete(4);
dump(arr);
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.delete()](../objects/array/delete.md)