# ArrayContainsNoCase()

Returns the position of the first element in the array whose string value contains the substring passed (not case sensitive), or 0 if no such element is found.

```
ArrayContainsNoCase( haystack=array, needle=object, substringMatch=boolean );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| haystack | array | Yes | The array in which to search for the substring *Alias: array, arr* |  |
| needle | object | Yes | The substring to search for (not case sensitive) *Alias: value, object, obj, o* |  |
| substringMatch | boolean | No | If set to true then if a then a substring match will also return true. This will only work with simple values. Passing true with complex objects will throw an exception. | false |

# Examples

```cfml
words           = [ 'Hello' , 'World' ];
positionOfWorld = ArrayContainsNoCase( words, 'world' );
Echo( positionOfWorld ); // outputs 2
```







# Categories

[Arrays](../../categories/array.md)

# See Also

[ArrayContains()](arraycontains.md), [array.containsNoCase()](../objects/array/containsnocase.md)