# ArrayContains()

Returns the position of the first element in the array that matches the item that we are searching for, or 0 if the item is not found.

```
ArrayContains( haystack=array, needle=object, substringMatch=boolean );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| haystack | array | Yes | The array in which to search for the item *Alias: array, arr* |  |
| needle | object | Yes | The item that we are looking for in the array *Alias: object, obj, o* |  |
| substringMatch | boolean | No | If set to true then a substring match will also return an array position. This will only work with simple values. Passing true with complex objects will throw an exception. |  |

# Usage Notes

Lucee returns the index of the match, while ACF returns a Boolean, both of which are truthy

# Examples

```cfml
	numbers = [ 4, 3, 2, 1 ];
	dump(var=numbers, label="numbers");

	positionOfThree = ArrayContains( numbers, 3);
	echo("Position of 3: " & positionOfThree & "<br>"); // outputs 2

	words = [ 'hello' , 'world' ];
	dump(var=words, label="Words");

	positionOfWorld = ArrayContains( words, 'world' );
	positionOfSubstring = ArrayContains( words, 'el', true ); // substring matching

	echo("Position of substring 'el': " & positionOfSubstring & "<br>" ); // outputs 1
	echo("Position of 'World': " & positionOfWorld); // outputs 2
```







# Categories

[Arrays](../../categories/array.md), [Compatibility / Migration with other CFML engines](../../categories/compat.md)

# See Also

[ArrayContainsNoCase()](arraycontainsnocase.md), [ArrayFind()](arrayfind.md), [array.contains()](../objects/array/contains.md)