# ArrayAppend()

Appends an array element to an array.

```
ArrayAppend( array=array, value=any, merge=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array | array | Yes | The array to which the element should be appended. |  |
| value | any | Yes | The element to append. Can be any type. *Alias: object, obj* |  |
| merge | boolean | No | This argument only applies when the value is an array. If set to true appends array elements individually to the source array. If false (default) the complete array is added as one element at the end, in the source array. |  |

# Examples

```cfml
numbers = [ 1, 2, 3, 4 ];
ArrayAppend( numbers, 5 );
Dump( numbers ); // Outputs [ 1, 2, 3, 4, 5 ]

numbers     = [ 1, 2, 3, 4 ];
moreNumbers = [ 5, 6, 7, 8 ];
ArrayAppend( numbers, moreNumbers );
Dump( numbers ); // Outputs [ 1, 2, 3, 4, [ 5, 6, 7, 8 ] ]

numbers     = [ 1, 2, 3, 4 ];
moreNumbers = [ 5, 6, 7, 8 ];
ArrayAppend( numbers, moreNumbers, true );
Dump( numbers ); // Outputs [ 1, 2, 3, 4, 5, 6, 7, 8 ]


```







# Categories

[Arrays](../../categories/array.md)

# See Also

[array.append()](../objects/array/append.md)