# Argon2CheckHash()

Returns hash of input using Argon2.

**Introduced:** 5.3.8.43

**Requires Extension:** [Argon2 Extension](https://download.lucee.org/#7891D723-8F78-45F5-B7E333A22F8467CA)

```
Argon2CheckHash( input=string, hash=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| input | string | Yes | Input string. |  |
| hash | string | Yes | Argon2 hash to compare against input string |  |

# Examples

```cfml
    secret = createUUID();
    dump(var=secret, label="input string");
    
    hashed = generateArgon2Hash(secret);
    dump(var=hashed, label="generateArgon2Hash");
    
    decoded= argon2checkhash(secret, hashed);
    dump(var=decoded, label="argon2checkhash matches");
```







# Categories

[Cryptography](../../categories/crypto.md)

# See Also

[GenerateArgon2Hash()](generateargon2hash.md)