# Functions

Aside from [Tags](tags.md), Lucee Server provides you with a huge number of built in functions, over 650 of them in fact!

Use the A-Z index below to browse the entire index of built in Lucee functions.

Functions can be called with a struct containing the arguments using *argumentCollection*, Tags use *attributeCollection*

```cfml
args = { file="myLog", text="argumentCollection is handy" };
writeLog(argumentCollection=args);
```

- [Abs()](functions/abs.md) - Absolute-value function. The absolute value of a number is the number without its sign.
- [ACos()](functions/acos.md) - Returns the angle whose cosine is the value passed as the argument.
- [AddSOAPRequestHeader()](functions/addsoaprequestheader.md) - Adds a SOAP header to a web service request before making the request.
- [AddSOAPResponseHeader()](functions/addsoapresponseheader.md) - Adds a SOAP response header to a web service response. Call only from within a CFC web service function that is processing a request as a SOAP web service.
- [AIGetMetaData()](functions/aigetmetadata.md) - Retrieves metadata about a configured AI endpoint. 
Returns information about the endpoint's configuration, 
and optionally detailed information about available models and associated files.
- [AIHas()](functions/aihas.md) - Checks whether a specific AI endpoint is configured and available for use.
- [AjaxOnLoad()](functions/ajaxonload.md) - Causes the specified JavaScript function to run when the page loads.
- [ApplicationPathCacheClear()](functions/applicationpathcacheclear.md) - flush the application.[cfc|cfm] path cache
- [ApplicationStartTime()](functions/applicationstarttime.md) - Provides information about the time when the current application scope was created.
- [ApplicationStop()](functions/applicationstop.md) - stops the current application context
- [Argon2CheckHash()](functions/argon2checkhash.md) - Returns hash of input using Argon2.
- [Array()](functions/array.md) - Creates a new array
- [ArrayAppend()](functions/arrayappend.md) - Appends an array element to an array.
- [ArrayAvg()](functions/arrayavg.md) - Calculates the average of the values in an array.
All elements in the array must contain values that can be automatically converted to numeric.
- [ArrayClear()](functions/arrayclear.md) - Removes all elements from an array.
- [ArrayContains()](functions/arraycontains.md) - Returns the position of the first element in the array that matches the item that we are searching for, or 0 if the item is not found.
- [ArrayContainsNoCase()](functions/arraycontainsnocase.md) - Returns the position of the first element in the array whose string value contains the substring passed (not case sensitive), or 0 if no such element is found.
- [ArrayDelete()](functions/arraydelete.md) - Deletes specified object from given array
- [ArrayDeleteAt()](functions/arraydeleteat.md) - Deletes an element from an array and resizes the array so that the deleted element doesn't leave a gap.
- [ArrayDeleteNoCase()](functions/arraydeletenocase.md) - Deletes specified object from given array, in case of a string the case of the string does not matter.
- [ArrayEach()](functions/arrayeach.md) - call the given UDF/Closure with every value in the array.
- [ArrayEvery()](functions/arrayevery.md) - This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.
- [ArrayFilter()](functions/arrayfilter.md) - This function creates a new Array that returns all the values from an array that match the given filter.
- [ArrayFind()](functions/arrayfind.md) - These functions searches the array for the specified object.
- [ArrayFindAll()](functions/arrayfindall.md) - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- [ArrayFindAllNoCase()](functions/arrayfindallnocase.md) - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- [ArrayFindNoCase()](functions/arrayfindnocase.md) - These functions performs a case-insensitive search in the array for the specified object.
- [ArrayFirst()](functions/arrayfirst.md) - Returns the first item from an array. Throws an error if the array is empty.
- [ArrayIndexExists()](functions/arrayindexexists.md) - Returns whether there exists an item in the array at the selected index.
- [ArrayInsertAt()](functions/arrayinsertat.md) - Inserts a value at the specified position in the array.
If the element is inserted before the end of the array, Lucee shifts the positions of all elements with a higher index to make room.
- [ArrayIsDefined()](functions/arrayisdefined.md) - Returns whether there exists an item in the array at the selected index.
- [ArrayIsEmpty()](functions/arrayisempty.md) - Determines if the array is empty.
- [ArrayLast()](functions/arraylast.md) - Returns the last element of an array
- [ArrayLen()](functions/arraylen.md) - Returns the length of a given array
- [ArrayMap()](functions/arraymap.md) - Calls the given closure with every element in the given array.
the function returns an array that contains all values returned by the closure.
- [ArrayMax()](functions/arraymax.md) - Returns the largest numeric value in an array. If the array
parameter value is an empty array, returns zero.
All elements must contain values that can be automatically
converted to numeric values.
- [ArrayMedian()](functions/arraymedian.md) - Calculates the Median value of items in an array.
- [ArrayMerge()](functions/arraymerge.md) - This function creates a new array with data from the two passed arrays. To add all the data from one array into another without creating a new array see the built in function ArrayAppend(arr1, arr2, true).
- [ArrayMid()](functions/arraymid.md) - Extracts a sub array from an array.
- [ArrayMin()](functions/arraymin.md) - Returns the smallest numeric value in an array. If the array
parameter value is an empty array, returns zero.
All elements must contain values that can be automatically
converted to numeric values.
- [ArrayNew()](functions/arraynew.md) - create a new array
- [ArrayPop()](functions/arraypop.md) - pops the last element from an array. In case the array is empty an exception is thrown, 
unless the second argument "defaultValue" is provided, in that case that value is returned.
- [ArrayPrepend()](functions/arrayprepend.md) - Inserts an array element at the beginning of an array
and shifts the positions of the existing elements to
make room.
- [ArrayPush()](functions/arraypush.md) - Inserts an array element at the end of an array and return the new size of the array.
- [ArrayReduce()](functions/arrayreduce.md) - Iterates over every entry of the given array and calls the closure with every element. 
This function will reduce the array to a single value and will return the value.
- [ArrayRemoveDuplicates()](functions/arrayremoveduplicates.md) - Removes duplicate values from array.
- [ArrayResize()](functions/arrayresize.md) - Resets an array to a specified minimum number of elements.
- [ArrayReverse()](functions/arrayreverse.md) - Returns a new array, with all the elements reversed
- [ArraySet()](functions/arrayset.md) - In a one-dimensional array, sets the elements in a specified
index range to a value. Useful for initializing an array after
a call to ArrayNew.
- [ArrayShift()](functions/arrayshift.md) - pops the first element from an array and shift the rest of the values to the left. In case the array is empty an exception is thrown, 
unless the second argument "defaultValue" is provided, in that case that value is returned.
- [ArraySlice()](functions/arrayslice.md) - Returns a new array, from the start position up to the count of elements
- [ArraySome()](functions/arraysome.md) - This function calls a given closure/function with every element in a given array and returns true, if one of the closure calls returns true.
- [ArraySort()](functions/arraysort.md) - Sorts array elements numerically or alphanumerically.
- [ArraySplice()](functions/arraysplice.md) - Modifies an array by removing elements and adding new elements. 
It starts from the index, removes as many elements as specified by elementCountForRemoval, 
and puts the replacements starting from index position.
Return the removed elements.
- [ArraySum()](functions/arraysum.md) - The sum of values in an array. If the array parameter value is
an empty array, returns zero.
- [ArraySwap()](functions/arrayswap.md) - Swaps array values of an array at specified positions. This
function is more efficient than multiple cfset tags
- [ArrayToList()](functions/arraytolist.md) - Transform the array to a list of elements delimiter by the given string
- [ArrayToStruct()](functions/arraytostruct.md) - Transform the array to a struct, by default, the index of the array is the key of the struct
- [ArrayUnShift()](functions/arrayunshift.md) - Adds an element at the beginning of the array and shifts the rest of the elements to the right.
- [Asc()](functions/asc.md) - Determines the value of a character.
- [ASin()](functions/asin.md) - Determines the arcSine of a number. The arcSine is the angle
whose sine is number.
- [astFromPath()](functions/astfrompath.md) - Parses a CFML file and returns its Abstract Syntax Tree (AST) representation.
The AST is a structured tree that represents the syntactic structure of the CFML code, making it useful for:
- **Code Analysis**: Static analysis, complexity metrics, dependency tracking
- **IDE Tooling**: Syntax highlighting, autocomplete, refactoring support  
- **Transformation**: Code generation, minification, transpilation
- **Documentation**: Automatic API documentation generation
- **Quality Assurance**: Linting, code style enforcement, security scanning
The returned AST uses **neutral, language-agnostic node types** following ESTree conventions such as `BinaryExpression`, `IfStatement`, `FunctionDeclaration`, and literal types. Each node includes **source position information** (line, column, offset) for precise error reporting and IDE integration.
- [astFromString()](functions/astfromstring.md) - **Parses CFML source code from a string and returns its Abstract Syntax Tree (AST) representation.**
The AST is a structured tree that represents the syntactic structure of the CFML code, making it useful for:
- **Code Analysis**: Static analysis, complexity metrics, dependency tracking
- **IDE Tooling**: Syntax highlighting, autocomplete, refactoring support  
- **Transformation**: Code generation, minification, transpilation
- **Documentation**: Automatic API documentation generation
- **Quality Assurance**: Linting, code style enforcement, security scanning
The returned AST uses **neutral, language-agnostic node types** following ESTree conventions such as `BinaryExpression`, `IfStatement`, `FunctionDeclaration`, and literal types. Each node includes **source position information** for precise error reporting and IDE integration.
- [Atn()](functions/atn.md) - ArcTangent function. The arcTangent is the angle whose tangent
is number.
- [Beat()](functions/beat.md) - Outputs the current swatch/beat time.
- [BinaryDecode()](functions/binarydecode.md) - Converts a string to a binary object. Used to convert
binary data that has been encoded into string format
back into binary data.
- [BinaryEncode()](functions/binaryencode.md) - Converts binary data to a string.
- [BitAnd()](functions/bitand.md) - Performs a bitwise logical AND operation.
- [BitMaskClear()](functions/bitmaskclear.md) - Performs a bitwise mask clear operation.
- [BitMaskRead()](functions/bitmaskread.md) - Performs a bitwise mask read operation.
- [BitMaskSet()](functions/bitmaskset.md) - Performs a bitwise mask set operation.
- [BitNot()](functions/bitnot.md) - Performs a bitwise logical NOT operation.
- [BitOr()](functions/bitor.md) - Performs a bitwise logical OR operation.
- [BitSHLN()](functions/bitshln.md) - Performs a bitwise shift-left, no-rotation operation.
- [BitSHRN()](functions/bitshrn.md) - Performs a bitwise shift-right, no-rotation operation.
- [BitXor()](functions/bitxor.md) - Performs a bitwise logical XOR operation.
- [BooleanFormat()](functions/booleanformat.md) - True, for a non-zero value; False, otherwise.
- [BundleInfo()](functions/bundleinfo.md) - if the given object is loaded by an OSGi bundle, this function is returning information about that bundle
- [CacheClear()](functions/cacheclear.md) - Flushes the cache
- [CacheCount()](functions/cachecount.md) - Returns the amount (integer) of keys stored in the cache.
- [CacheDelete()](functions/cachedelete.md) - Deletes a single element from the cache.
- [CacheGet()](functions/cacheget.md) - Gets an object that is stored in the cache.
- [CacheGetAll()](functions/cachegetall.md) - this function return a structure containing all elements inside the cache.
- [CacheGetAllIds()](functions/cachegetallids.md) - this function return an array containing all keys inside the cache.
- [CacheGetDefaultCacheName()](functions/cachegetdefaultcachename.md) - return the default cache name for a specific type
- [CacheGetMetadata()](functions/cachegetmetadata.md) - returns a structure with some Metadata regarding the cache elements
- [CacheGetProperties()](functions/cachegetproperties.md) - Gets the cache properties for the object cache, the page cache, or both.
- [CacheIdExists()](functions/cacheidexists.md) - Returns true/false whether the cache contains an element with the certain id.
- [CacheKeyExists()](functions/cachekeyexists.md) - this function is deprecated
- [CachePut()](functions/cacheput.md) - Stores an object in the cache, with a life time and an idle time.
- [CacheRegionExists()](functions/cacheregionexists.md) - this function exists solely for the purpose of compatibility with other CFML Engines.
- [CacheRegionNew()](functions/cacheregionnew.md) - This function exists solely for the purpose of compatibility with other CFML Engines.
- [CacheRegionRemove()](functions/cacheregionremove.md) - this function exists solely for the purpose of compatibility with other CFML Engines.
- [CacheRemove()](functions/cacheremove.md) - removes elements from cache defined with argument ids.
- [CacheRemoveAll()](functions/cacheremoveall.md) - this function is deprecated, use instead cacheClear. Removes all elements from the cache
- [CacheSetProperties()](functions/cachesetproperties.md) - This function is not supported by Lucee
- [CallStackDump()](functions/callstackdump.md) - Dump the context (stacktrace) of the current position.
- [CallStackGet()](functions/callstackget.md) - Returns the context (stacktrace) of the current position.
- [Canonicalize()](functions/canonicalize.md) - Canonicalization is simply the operation of reducing a possibly encoded string down to its simplest form. 
This is important, because attackers frequently use encoding to change their input in a way that will bypass validation filters, 
but still be interpreted properly by the target of the attack. 
Note that data encoded more than once is not something that a normal user would generate and should be regarded as an attack.
- [Ceiling()](functions/ceiling.md) - Determines the closest integer that is greater than a
specified number.
- [Cfusion_decrypt()](functions/cfusion_decrypt.md) - Decrypts the given string, alias for function call decrypt(string,key,"cfmx_compat","hex")
- [Cfusion_encrypt()](functions/cfusion_encrypt.md) - Encrypts the given string, alias for function call encrypt(string,key,"cfmx_compat","hex")
- [CharsetDecode()](functions/charsetdecode.md) - Converts as string to a binary representation.
- [CharsetEncode()](functions/charsetencode.md) - Uses the specified encoding to convert binary data to a string.
- [Chr()](functions/chr.md) - Returns the character represented by the ascii value
- [CJustify()](functions/cjustify.md) - Returns the given string justified to the center, padding out the words with spaces accordingly
- [ClearTimeZone()](functions/cleartimezone.md) - resets the timezone for the current request to Lucee default setting.
- [CollectionEach()](functions/collectioneach.md) - call the given UDF/Closure with every entry (key/value) in the given collection.
- [CollectionEvery()](functions/collectionevery.md) - This function calls a given closure/function with every element in a given collection and returns true, if all of the closure calls returns true.
- [CollectionFilter()](functions/collectionfilter.md) - This function creates a new collection that returns all entries from an collection that match the given filter.
- [CollectionMap()](functions/collectionmap.md) - Calls the given closure with every element in the given collection.
the function returns an array or struct (depending on the input) that contains all values returned by the closure.
- [CollectionReduce()](functions/collectionreduce.md) - Iterates over every entry of the collection and calls the closure with every element. 
This function will reduce the array to a single value and will return the value.
- [CollectionSome()](functions/collectionsome.md) - This function calls a given closure/function with every element in a given collection and returns true, if one of the closure calls returns true.
- [Compare()](functions/compare.md) - Performs a case-sensitive comparison of two strings.
-1, if string1 is less than string2
0, if string1 is equal to string2
1, if string1 is greater than string2
- [CompareNoCase()](functions/comparenocase.md) - Performs a case-insensitive comparison of two strings.
An indicator of the difference:
A negative number, if string1 is less than string2
0, if string1 is equal to string2
A positive number, if string1 is greater than string2
- [ComponentCacheClear()](functions/componentcacheclear.md) - flush the component path cache
- [ComponentCacheList()](functions/componentcachelist.md) - list elements in the component path cache
- [ComponentInfo()](functions/componentinfo.md) - this function is deprecated, use function getMetadata instead.
- [ComponentListPackage()](functions/componentlistpackage.md) - List all components in a certain package, throws an application exception if package does not exist.
- [Compress()](functions/compress.md) - Compress given source to different formats.
- [ConfigImport()](functions/configimport.md) - Imports configuration using the "CFConfig.json" format.
- [configTranslate()](functions/configtranslate.md) - translate an old Lucee XML configuration to the new CFConfig.json configuration
- [ContractPath()](functions/contractpath.md) - Does the opposite of the function expandPath(). Tries to match given absolute path to the mappings in the environment.  When no mappings match, lucee creates a relative path from the current position.
- [Cos()](functions/cos.md) - Calculates the cosine of an angle that is entered
in radians.
A number; the cosine of the angle.
- [CreateAISession()](functions/createaisession.md) - Creates a new AI session for interaction with Large Language Models (LLMs). 
The session maintains conversation history and context between interactions. 
Each session can be configured with different parameters to optimize for specific use cases like code analysis, content generation, or data processing.
Common usage patterns:
- Exception analysis and debugging assistance
- Code documentation generation
- Query optimization suggestions
- Security review assistance
- Performance optimization recommendations
The session persists until explicitly terminated or the application restarts.
- [CreateDate()](functions/createdate.md) - Creates a CFML date object from the given year, month and day
- [CreateDateTime()](functions/createdatetime.md) - Creates a CFML date/time object from the given year, month, day, hour, minute and second
- [CreateDynamicProxy()](functions/createdynamicproxy.md) - Wraps the given component with a Java class that implements the specified interfaces.
If no interfaces are provided, Lucee will create a proxy based on the component's interface itself.
- [CreateGUID()](functions/createguid.md) - Creates a Globally Unique Identifier (GUID). A GUID is a
36-character string representation of a unique 128-bit integer
xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx where x is a hexadecimal digit.
A GUID is just a UUID with one extra dash.
- [CreateObject()](functions/createobject.md) - The CreateObject function takes different arguments depending on the value of the first argument:
- [CreateODBCDate()](functions/createodbcdate.md) - Creates an ODBC date object.
- [CreateODBCDateTime()](functions/createodbcdatetime.md) - Creates an ODBC date-time object.
- [CreateODBCTime()](functions/createodbctime.md) - Creates an ODBC time object.
- [CreateTime()](functions/createtime.md) - Creates a CFML time object from the given hour, minute and second
- [CreateTimeSpan()](functions/createtimespan.md) - Creates a timespan object that defines a time period.
- [CreateULID()](functions/createulid.md) - Generates a ULID (Universally Unique Lexicographically Sortable Identifier)
- [CreateUniqueId()](functions/createuniqueid.md) - Creates a Unique Identifier.
- [CreateUUID()](functions/createuuid.md) - Creates a Universally Unique Identifier (UUID). A UUID is a
35-character string representation of a unique 128-bit integer
xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx where x is a hexadecimal digit.
- [CreateWebSocketClient()](functions/createwebsocketclient.md) - Creates a websocket client.
- [CSRFGenerateToken()](functions/csrfgeneratetoken.md) - Provides a random token and stores it in the session.
- [CSRFVerifyToken()](functions/csrfverifytoken.md) - Validates the given token against the same stored in the session for a specific key.
- [CtCacheClear()](functions/ctcacheclear.md) - flush the custom tag path cache
- [CtCacheList()](functions/ctcachelist.md) - list elements in the custom tag path cache
- [DatasourceFlushMetaCache()](functions/datasourceflushmetacache.md) - Flush the meta data stored for a certain datasource used for stored procedures, this is only supported for Oracle datasources
- [DateAdd()](functions/dateadd.md) - Adds units of time to a date object.
- [DateCompare()](functions/datecompare.md) - Compares two dates to a given optional resolution
- [DateDiff()](functions/datediff.md) - Determines the number of given date parts between two different dates
- [DateFormat()](functions/dateformat.md) - Formats a date string to a given output
- [DatePart()](functions/datepart.md) - Extracts the given date part from the date object
- [DateTimeFormat()](functions/datetimeformat.md) - Formats a date/time string to a given output
- [Day()](functions/day.md) - Determines the day of the month, in a date.
The ordinal for the day of the month, ranging from 1 to 31.
- [DayOfWeek()](functions/dayofweek.md) - Determines the day of the week, in a date.
- [DayOfWeekAsString()](functions/dayofweekasstring.md) - Determines the day of the week as a string from 1-7
- [DayOfWeekShortAsString()](functions/dayofweekshortasstring.md) - Returns the string representation of the given day index in short form
- [DayOfYear()](functions/dayofyear.md) - Determines the day of the year, in a date.
- [DaysInMonth()](functions/daysinmonth.md) - Determines the number of days in a month.
- [DaysInYear()](functions/daysinyear.md) - Determines the number of days in a year.
- [DbPoolClear()](functions/dbpoolclear.md) - clears all existing datasource connection
- [DE()](functions/de.md) - Postpones evaluation of a string as an expression, when it is
passed as a parameter to the IIf or Evaluate functions. Escapes
any double quotation marks in the parameter and wraps the
result in double quotation marks.
- [DebugAdd()](functions/debugadd.md) - Adding data to debug output.
- [DecimalFormat()](functions/decimalformat.md) - Converts a number to a decimal-formatted string.
- [DecodeForHtml()](functions/decodeforhtml.md) - Decodes the given encoded string.
- [DecodeFromURL()](functions/decodefromurl.md) - Decodes a string that has been encoded in the URL using the encodeForURL.
this function is deprecated, use function ESAPIDecode('url',...) instead.
- [DecrementValue()](functions/decrementvalue.md) - this function is deprecated, use instead the -- operator;Decrements the current number by one
- [Decrypt()](functions/decrypt.md) - Decrypts a string that is encrypted with the Encrypt function.
- [DecryptBinary()](functions/decryptbinary.md) - Decrypts the given binary with the optional parameters
- [DeleteClientVariable()](functions/deleteclientvariable.md) - Removes the element represented by the key from the [client] scope
- [DeserializeJSON()](functions/deserializejson.md) - Converts a JSON (JavaScript Object Notation) or JSON5 string data representation into CFML data, such as a struct or array.
- [DirectoryCopy()](functions/directorycopy.md) - Copies the contents of a directory to a destination directory.
- [DirectoryCreate()](functions/directorycreate.md) - Creates new directory for specified path
- [DirectoryDelete()](functions/directorydelete.md) - Deltes directory for given path
- [DirectoryExists()](functions/directoryexists.md) - Determines whether a directory exists.
- [DirectoryInfo()](functions/directoryinfo.md) - returns detailed info about the given directory.
- [DirectoryList()](functions/directorylist.md) - Lists the contents of a specified directory and returns the list as an array or a query.
- [DirectoryRename()](functions/directoryrename.md) - Renames given directory
- [DollarFormat()](functions/dollarformat.md) - Formats a string in U.S. format.
- [Dump()](functions/dump.md) - Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.
- [Duplicate()](functions/duplicate.md) - Returns a new duplicated version of the given object, removing all references to the old one
- [Each()](functions/each.md) - call the given UDF/Closure with every entry (key/value) in the given collection.
- [EC2describeInstances()](functions/ec2describeinstances.md) - This function interfaces with the EC2 service to retrieve detailed information about specified EC2 instances. It supports custom filtering, specific instance IDs, regional targeting, and legacy mode handling.
- [Echo()](functions/echo.md) - Writes the given string to the main response buffer regardless of
conditions established by the cfsetting tag. see also function writeOutput.
- [Empty()](functions/empty.md) - This function is deprecated, use instead IsEmpty()
- [EncodeForCSS()](functions/encodeforcss.md) - Encodes the given string for safe output in CSS to reduce the risk of Cross Site Scripting attacks.
- [EncodeForDN()](functions/encodefordn.md) - Encodes the given string for safe output in LDAP Distinguished Names.
- [EncodeForHTML()](functions/encodeforhtml.md) - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- [EncodeForHTMLAttribute()](functions/encodeforhtmlattribute.md) - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- [EncodeForJavaScript()](functions/encodeforjavascript.md) - Encodes the given string for safe output in JavaScript to reduce the risk of Cross Site Scripting attacks.
- [EncodeForLDAP()](functions/encodeforldap.md) - Encodes the given string for safe output in LDAP queries.
- [EncodeForSQL()](functions/encodeforsql.md) - Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks. _This method is not recommended_ - the use of query parameters are strongly encouraged as a stronger alternative.
- [EncodeForURL()](functions/encodeforurl.md) - Encodes the given string for safe output in a URL.
- [EncodeForXML()](functions/encodeforxml.md) - Encodes the given string for safe output in XML to reduce the risk of Cross Site Scripting attacks.
- [EncodeForXMLAttribute()](functions/encodeforxmlattribute.md) - Encodes the given string for safe output in XMLAttribute to reduce the risk of Cross Site Scripting attacks.
- [EncodeForXPath()](functions/encodeforxpath.md) - Encodes the given string for safe use in an XPath Query.
- [Encrypt()](functions/encrypt.md) - Encrypts a string. Uses a symmetric key-based algorithm, in which the same key is used to encrypt and decrypt a string.
- [EncryptBinary()](functions/encryptbinary.md) - Encrypts binary data using a specific algorithm and encoding method.
- [EntityDelete()](functions/entitydelete.md) - Deletes the record from the database for the specified entity.
EntityDelete(entity)
- [EntityLoad()](functions/entityload.md) - Loads and returns an array of entities of the specified entityname.
- [EntityLoadByExample()](functions/entityloadbyexample.md) - Loads and returns an array of objects that match the sample entity.
- [EntityLoadByPK()](functions/entityloadbypk.md) - Loads and returns an array of objects for given primary key.
- [EntityMerge()](functions/entitymerge.md) - Attaches given entity to current ORM session
- [EntityNameArray()](functions/entitynamearray.md) - return all loaded entities as array
- [EntityNameList()](functions/entitynamelist.md) - return all loaded entities as string list
- [EntityNew()](functions/entitynew.md) - Creates a new instance of the persistent CFC with the entity name that you provide.
- [EntityReload()](functions/entityreload.md) - Reloads data for an entity that is already loaded.
- [EntitySave()](functions/entitysave.md) - Saves or updates data of the entity and all related entities to the database.
- [EntityToQuery()](functions/entitytoquery.md) - Converts the input entity object or the input array of entity objects to a query object.
- [ESAPIDecode()](functions/esapidecode.md) - Decodes a string that has been encoded with ESAPIEncode.
- [ESAPIEncode()](functions/esapiencode.md) - Encodes the given string for safe output to reduce the risk of Cross Site Scripting attacks.
- [Evaluate()](functions/evaluate.md) - Evaluates one or more string expressions, dynamically, from
left to right. (The results of an evaluation on the left can
have meaning in an expression to the right.) Returns the
result of evaluating the rightmost expression.
- [Exp()](functions/exp.md) - Calculates the exponent whose base is e that represents number.
- [ExpandPath()](functions/expandpath.md) - Creates an absolute, platform-appropriate path that is
equivalent to the value of relative_path, appended to the base
path. This function (despite its name) can accept an absolute
or relative path in the relative_path attribute
- [ExtensionExists()](functions/extensionexists.md) - Checks if a certain extension exists or not.
- [ExtensionInfo()](functions/extensioninfo.md) - Returns the detailed info about the extension.
- [ExtensionList()](functions/extensionlist.md) - Checks if a certain extension exists or not.
- [Extract()](functions/extract.md) - Extract the data of a compressed file
- [FileAppend()](functions/fileappend.md) - appends the entire content to the specified file.
- [FileClose()](functions/fileclose.md) - Closes an file that is open.
- [FileCopy()](functions/filecopy.md) - Copies the specified on-disk or in-memory source file to the specified destination file.
- [FileDelete()](functions/filedelete.md) - Deletes the specified file on the server.
- [FileExists()](functions/fileexists.md) - Determines whether a file exists
- [FileGetMimeType()](functions/filegetmimetype.md) - Returns the mimetype of the given file
- [FileInfo()](functions/fileinfo.md) - returns detailed info about the given file.
- [FileIsEOF()](functions/fileiseof.md) - Determines whether Lucee has reached the end of the file while reading it.
- [FileModeToSymbolic()](functions/filemodetosymbolic.md) - Converts a mode mask to it's symbolic representation.
- [FileMove()](functions/filemove.md) - Moves file from source to destination
- [FileOpen()](functions/fileopen.md) - Opens an file to read, write, or append.
- [FileRead()](functions/fileread.md) - Reads an on-disk or in-memory text file or a file object created with the FileOpen function.
- [FileReadBinary()](functions/filereadbinary.md) - Reads an on-disk or in-memory binary file (such as an executable or image file) on the server, into a binary object
- [FileReadLine()](functions/filereadline.md) - Reads a line from an file.
- [FileSeek()](functions/fileseek.md) - Shifts the file pointer to the given position. The file must be opened with seekable option
- [FileSetAccessMode()](functions/filesetaccessmode.md) - Sets the attributes of an on-disk file on UNIX or Linux. This function does not work with in-memory files.
- [FileSetAttribute()](functions/filesetattribute.md) - For the given path, sets the file attributes.
- [FileSetLastModified()](functions/filesetlastmodified.md) - For the given file, set the last modification date
- [FileSkipBytes()](functions/fileskipbytes.md) - Shifts the file pointer by the given number of bytes.
- [FileTouch()](functions/filetouch.md) - Touches given file, creates the file if not already exists.
- [FileUpload()](functions/fileupload.md) - Uploads file to a directory on the server.
- [FileUploadAll()](functions/fileuploadall.md) - Uploads file to a directory on the server.
- [FileWrite()](functions/filewrite.md) - If you specify a file path, writes the entire content to the specified file. If you specify a file object, writes text or binary data to the file object.
- [FileWriteLine()](functions/filewriteline.md) - Opens up the file (or uses the existing file object) and appends the given line of text
- [Find()](functions/find.md) - Finds the first occurrence of a substring in a string, from a
specified start position. The search is case-sensitive.
- [FindLast()](functions/findlast.md) - Finds the last occurrence of a substring in a string, from a
specified start position. The search is case-sensitive.
- [FindLastNoCase()](functions/findlastnocase.md) - Finds the last occurrence of a substring in a string, from a
specified start position. If substring is not in string,
returns zero. The search is case-insensitive.
- [FindNoCase()](functions/findnocase.md) - Finds the first occurrence of a substring in a string, from a
specified start position. If substring is not in string,
returns zero. The search is case-insensitive.
- [FindOneOf()](functions/findoneof.md) - Finds the first occurrence of any one of a set of characters
in a string, from a specified start position. The search is
case-sensitive.
- [FirstDayOfMonth()](functions/firstdayofmonth.md) - Determines the ordinal (day number, in the year) of the first
day of the month in which a given date falls.
- [Fix()](functions/fix.md) - Converts a real number to an integer.
- [Floor()](functions/floor.md) - Calculates the closest integer that is smaller than number.
- [FormatBaseN()](functions/formatbasen.md) - String Converts number to a string, in the base specified by
radix. For example: #FormatBaseN(1024,16)#
- [GatewayAction()](functions/gatewayaction.md) - Executes a specifc action for a gateway instance.
- [GatewayState()](functions/gatewaystate.md) - Return the current state for the given gateway id.
- [Generate3DESKey()](functions/generate3deskey.md) - Generates a secure key value for use in the encrypt function with the 3DES algorithm.
- [GenerateArgon2Hash()](functions/generateargon2hash.md) - Returns hash of input using Argon2.
- [GeneratePBKDFkey()](functions/generatepbkdfkey.md) - Implementation of Password-Based Key-Derivation Function (PBKDF).
- [GenerateRSAkeys()](functions/generatersakeys.md) - Generates a secure keys (private and public) for use in the encrypt function with the RSA algorithm.
- [GenerateSecretKey()](functions/generatesecretkey.md) - Gets a secure key value for use in the encrypt function.
- [GetApplicationMetadata()](functions/getapplicationmetadata.md) - return all data from this scope, when using an application.cfc or all setting defined in tag cfapplication
- [GetApplicationSettings()](functions/getapplicationsettings.md) - return all data from this scope, when using an application.cfc or all setting defined in tag cfapplication
- [GetAuthUser()](functions/getauthuser.md) - Returns the name of the currently authenticated user. 
This function checks the application's authentication system and returns the username of the logged-in user.
If no user is authenticated, it returns an empty string. 
The function first attempts to retrieve credentials from the application security context, and if none exist, 
it falls back to checking the HTTP servlet request for remote user information.
- [GetBaseTagData()](functions/getbasetagdata.md) - Used within a custom tag. Finds calling (ancestor) tag by
name and accesses its data.
- [GetBaseTagList()](functions/getbasetaglist.md) - Gets ancestor tag names, starting with the parent tag.
- [GetBaseTemplatePath()](functions/getbasetemplatepath.md) - Gets the absolute path of an application's base page.
- [GetBuiltInFunction()](functions/getbuiltinfunction.md) - return a build in function as an object, matching the given name, throws an exception when the function does not exist.
- [GetCanonicalPath()](functions/getcanonicalpath.md) - Returns the canonical pathname string based on the given string.
- [GetClassPath()](functions/getclasspath.md) - returns an array containing the Java classpath of the current environment.
- [GetClientVariablesList()](functions/getclientvariableslist.md) - Finds the client variables to which a page has write access.
Comma-delimited list of non-read-only client variables
- [GetComponentMetaData()](functions/getcomponentmetadata.md) - Gets metadata (such as the functions and implemented interfaces of a component) for a CFC or Interface.
- [GetComponentStaticScope()](functions/getcomponentstaticscope.md) - returns the static scope of a specific component, of course access rules apply.
- [GetContextInfo()](functions/getcontextinfo.md) - Returns information about the current context.
- [GetContextRoot()](functions/getcontextroot.md) - Returns path to the J2EE server context root for the current request.
- [GetCPUUsage()](functions/getcpuusage.md) - returns the CPU usage for a defined time range (default: 1000ms).
- [GetCurrentContext()](functions/getcurrentcontext.md) - this function is deprecated, use function CallStackGet instead.
- [GetCurrentTemplatePath()](functions/getcurrenttemplatepath.md) - Gets the absolute path of the page that calls this function.
- [GetDirectoryFromPath()](functions/getdirectoryfrompath.md) - Extracts a directory from an absolute path.
Returns the absolute path, without the filename.
- [GetEncoding()](functions/getencoding.md) - Returns the encoding (character set) of the Form or URL scope.
- [GetFileFromPath()](functions/getfilefrompath.md) - Extracts a filename from an absolute path.
- [GetFileInfo()](functions/getfileinfo.md) - Retrieves information about file.
- [GetFreeSpace()](functions/getfreespace.md) - Returns the number of unallocated bytes in the partition named by this abstract path name.
- [GetFunctionCalledName()](functions/getfunctioncalledname.md) - Returns the name of variable used to call the current function
- [GetFunctionData()](functions/getfunctiondata.md) - Returns information about a built in function (BIF)
- [GetFunctionKeywords()](functions/getfunctionkeywords.md) - returns all keywords defined with all functions
- [GetFunctionList()](functions/getfunctionlist.md) - Returns all the currently registered functions
- [GetHTTPRequestData()](functions/gethttprequestdata.md) - Makes HTTP request headers and body available to CFML pages.
Useful for capturing SOAP request data, which can be delivered
in an HTTP header.
- [GetHTTPRequestHeaders()](functions/gethttprequestheaders.md) - Returns a Struct with HTTP Request Headers
- [GetHttpTimeString()](functions/gethttptimestring.md) - Gets the current time, in the Universal Time code (UTC).
- [GetK2ServerDocCount()](functions/getk2serverdoccount.md) - This function is deprecated.
- [GetK2ServerDocCountLimit()](functions/getk2serverdoccountlimit.md) - This function is deprecated.
- [GetLocale()](functions/getlocale.md) - Gets the current geographic/language locale value.
- [GetLocaleDisplayName()](functions/getlocaledisplayname.md) - Gets a locale value and displays the name in a manner
that is appropriate to a specific locale. By default,
gets the current locale in the current locale's language.
- [GetLocaleInfo()](functions/getlocaleinfo.md) - returns info to a specific Locale
- [GetLocalHostIP()](functions/getlocalhostip.md) - Returns the localhost IP address, which is 127.0.0.1 for IPv4 and ::1 for IPv6 addresses.
- [GetLuceeId()](functions/getluceeid.md) - return ids of the current context
- [GetMemoryUsage()](functions/getmemoryusage.md) - Returns detailed information to the memory usage of the container.
- [GetMetadata()](functions/getmetadata.md) - Returns back meta information depending on the object passed in
- [GetMetricData()](functions/getmetricdata.md) - Gets server performance metrics.
- [GetNumericDate()](functions/getnumericdate.md) - Returns a real number whose integer part represents the number of days since the EPOCH and whose fractional part represents the time value expressed in hours then divided by 24
- [GetPageContext()](functions/getpagecontext.md) - Gets the current PageContext object that provides access to page attributes and configuration, request and response objects.
- [GetPrinterList()](functions/getprinterlist.md) - Gets a string list of available printers.
- [GetProfileSections()](functions/getprofilesections.md) - Gets all the sections of an initialization file.
An initialization file, as a struct whose format is as follows:
- Each initialization file section name is a key in the
struct
- Each list of entries in a section of an initialization
file is a value in the struct
- [GetProfileString()](functions/getprofilestring.md) - Gets an initialization file entry.
- [GetPropertyFile()](functions/getpropertyfile.md) - Read the properties from a properties file.
- [GetPropertyString()](functions/getpropertystring.md) - Sets the value of a property entry in a properties file.
- [GetReadableImageFormats()](functions/getreadableimageformats.md) - Returns a list of image formats that Lucee can read on the operating system where Lucee is deployed.
- [GetSOAPRequest()](functions/getsoaprequest.md) - Returns an XML object that contains the entire SOAP
request. Usually called from within a web service CFC.
- [GetSOAPRequestHeader()](functions/getsoaprequestheader.md) - Obtains a SOAP request header. Call only from within
a CFC web service function that is processing a request
as a SOAP web service.
- [GetSOAPResponse()](functions/getsoapresponse.md) - Returns an XML object that contains the entire
SOAP response after invoking a web service.
- [GetSOAPResponseHeader()](functions/getsoapresponseheader.md) - Returns a SOAP response header. Call this function
from within code that is invoking a web service after
making a web service request.
- [GetSystemFreeMemory()](functions/getsystemfreememory.md) - The amount of memory that is currently free, in bytes.
- [GetSystemPropOrEnvVar()](functions/getsystemproporenvvar.md) - Return the list of supported system properties or env vars Lucee supports.
- [GetSystemTotalMemory()](functions/getsystemtotalmemory.md) - The amount of memory that is available to the operating system, in bytes.
- [GetTagData()](functions/gettagdata.md) - Returns Information about a Tag as Struct
- [GetTagList()](functions/gettaglist.md) - Returns a struct containing all the Tags supported by Lucee.
- [GetTempDirectory()](functions/gettempdirectory.md) - Returns the full path to the currently assigned temporary directory, optionally creating a unique temp directory
- [GetTempFile()](functions/gettempfile.md) - Creates a unique temporary file with a prefix in a directory.
- [GetTemplatePath()](functions/gettemplatepath.md) - This function is deprecated.
Use the GetBaseTemplatePath() function instead.
- [GetTickCount()](functions/gettickcount.md) - Returns the elapsed time from a specific reference point, based on the specified `unit`. 
The default unit, "milli," represents milliseconds since midnight, January 1, 1970 UTC, and aligns with conventional system time. 
The "nano" and "micro" units offer high-resolution timing based on the Java Virtual Machine's internal clock, ideal for measuring elapsed time rather than absolute wall-clock time. 
These values are not tied to real-world dates but provide a consistent point of origin within the Java Virtual Machine for accurate time intervals. 
This function is well-suited for performance testing, such as timing code execution, by capturing precise intervals.
- [GetTimeZone()](functions/gettimezone.md) - returns the timezone defined for the current request.
- [GetTimeZoneInfo()](functions/gettimezoneinfo.md) - Returns a structure representing the current timezone
- [GetToken()](functions/gettoken.md) - Determines whether a token of the list in the delimiters
parameter is present in a string.
Returns the token found at position index of the string, as a
string. If index is greater than the number of tokens in the
string, returns an empty string.
- [GetTotalSpace()](functions/gettotalspace.md) - Returns the size of the partition named by this abstract pathname.
- [GetUserRoles()](functions/getuserroles.md) - Retrieves the list of roles for the current user.
- [GetVariable()](functions/getvariable.md) - Gets the variable referenced by the given parameter; may be fully qualified
- [GetVFSMetaData()](functions/getvfsmetadata.md) - Returns metadata about the Virtual File system (VFS)
- [GetWriteableImageFormats()](functions/getwriteableimageformats.md) - Returns a list of image formats that Lucee can write on the operating system where Lucee is deployed.
- [Hash()](functions/hash.md) - Returns the one-way hash of a variable-length input string based on the algorithm, producing a fixed-length string.
- [Hash40()](functions/hash40.md) - This function only exists for backward compatibility to Lucee 4.0
- [HMAC()](functions/hmac.md) - Creates a hash-based message authentication code (HMAC) 
- [Hour()](functions/hour.md) - Gets the current hour of the day.
Ordinal value of the hour, in the range 0 - 23.
- [HTMLCodeFormat()](functions/htmlcodeformat.md) - Replaces special characters in a string with their HTML-escaped
equivalents and inserts <pre> and </pre> tags at the beginning
and end of the string.
[version]
HTML version to use. currently ignored.
-1: The latest implementation of HTML
2.0: HTML 2.0 (Default)
3.2: HTML 3.2
- [HTMLEditFormat()](functions/htmleditformat.md) - Replaces special characters in a string with their
HTML-escaped equivalents.
[version]
HTML version to use. currently ignored.
-1: The latest implementation of HTML
2.0: HTML 2.0 (Default)
3.2: HTML 3.2
4.0: HTML 4.0
- [HtmlParse()](functions/htmlparse.md) - parse the given html (not only xhtml) as xml Object, work similar to xmlParse, but this function is very forgiving with the syntax..
- [IIf()](functions/iif.md) - Evaluates a Boolean conditional dynamic expression. Depending
on whether the expression is true or false, dynamically
evaluates one of two string expressions and returns the result.
- [ImageAddBorder()](functions/imageaddborder.md) - Adds a rectangular border around the outside edge of an image. The border can be a solid color or generated using various edge extension methods. The original image remains centered while the border increases the image dimensions.
- [ImageBlur()](functions/imageblur.md) - Applies a box blur filter to smooth an image by averaging pixel values within a square region. Useful for reducing image noise or creating soft focus effects.
- [ImageCaptcha()](functions/imagecaptcha.md) - Creates a captcha image
- [ImageClearRect()](functions/imageclearrect.md) - Clears the specified rectangle by filling it with the background color of the current drawing surface.
- [imagecoderinfo()](functions/imagecoderinfo.md) - Gives detailed information about all coder used by the image extension.
- [ImageCopy()](functions/imagecopy.md) - Creates a new image by copying a rectangular area from the source image. If destination coordinates are provided, the copied area is also drawn at the new location in the resulting image.
- [ImageCrop()](functions/imagecrop.md) - Crops an image to a specified rectangular area. The function modifies the original image by extracting the defined region. If the specified crop area extends beyond the image boundaries, the function automatically adjusts to fit within the image dimensions.
- [ImageDrawArc()](functions/imagedrawarc.md) - Draws a circular or elliptical arc.
- [ImageDrawBeveledRect()](functions/imagedrawbeveledrect.md) - Draws a rectangle with beveled edges.
- [ImageDrawCubicCurve()](functions/imagedrawcubiccurve.md) - Draws a cubic curve.
- [ImageDrawImage()](functions/imagedrawimage.md) - this function is deprecated, use ImagePaste instead. Draws a image on a image with the baseline of the first character positioned at (x,y) in the image.
- [ImageDrawLine()](functions/imagedrawline.md) - Draws a single line defined by two sets of x and y coordinates on a image.
- [ImageDrawLines()](functions/imagedrawlines.md) - Draws a sequence of connected lines defined by arrays of x and y coordinates.
- [ImageDrawOval()](functions/imagedrawoval.md) - Draws an oval.
- [ImageDrawPoint()](functions/imagedrawpoint.md) - Draws a point at the specified (x,y) coordinate.
- [ImageDrawQuadraticCurve()](functions/imagedrawquadraticcurve.md) - Draws a curved line. The curve is controlled by a single point.
- [ImageDrawRect()](functions/imagedrawrect.md) - Draws a rectangle.
- [ImageDrawRoundRect()](functions/imagedrawroundrect.md) - Draws a rectangle with rounded corners.
- [ImageDrawText()](functions/imagedrawtext.md) - Draws a text string on a image with the baseline of the first character positioned at (x,y) in the image.
- [ImageFilter()](functions/imagefilter.md) - the function ImageFilter allows to execute a filter against a image.
- [ImageFilterColorMap()](functions/imagefiltercolormap.md) - These are passed to the function ImageFilters (see ImageFilter documentation) which convert gray values to colors.
- [ImageFilterCurves()](functions/imagefiltercurves.md) - the curves for the wrap grid
- [ImageFilterKernel()](functions/imagefilterkernel.md) - These are passed to the function ImageFilters 
- [ImageFilterWarpGrid()](functions/imagefilterwarpgrid.md) - A warp grid. These are passed to the function ImageFilters (see ImageFilter documentation).
- [ImageFlip()](functions/imageflip.md) - Transforms an image by flipping or rotating it along specified axes. This operation modifies the original image in place.
- [ImageFonts()](functions/imagefonts.md) - return all available
- [ImageFormats()](functions/imageformats.md) - return all available readers and writers
- [ImageGetBlob()](functions/imagegetblob.md) - Retrieves the bytes of the underlying image. The bytes are in the same image format as the source image.
- [ImageGetBufferedImage()](functions/imagegetbufferedimage.md) - Returns the java.awt.BufferedImage object underlying the current image.
- [ImageGetEXIFMetadata()](functions/imagegetexifmetadata.md) - Retrieves the Exchangeable Image File Format (EXIF) headers in an image as a CFML structure.
- [ImageGetEXIFTag()](functions/imagegetexiftag.md) - Retrieves the specified EXIF tag in an image.
- [ImageGetHeight()](functions/imagegetheight.md) - Retrieves the height of the image in pixels.
- [ImageGetIptcMetadata()](functions/imagegetiptcmetadata.md) - Retrieves the International Press Telecommunications Council (IPTC )headers in a image as a struct. The IPTC metadata contains text that describes the image that is stored with it. IPTC metadata includes, but is not limited to, caption, keywords, credit, copyright, object name, created date, byline, headline, and source.
- [ImageGetWidth()](functions/imagegetwidth.md) - Retrieves the width of the specified image.
- [ImageGrayscale()](functions/imagegrayscale.md) - Converts a image to grayscale.
- [ImageInfo()](functions/imageinfo.md) - Returns a structure containing image information. When called with an image argument, returns details about the specific image including height, width, color model, size, and filename. When called without arguments, returns information about the Lucee image processing extension including its OSGi bundle version and status.
- [ImageNegative()](functions/imagenegative.md) - Creates a negative version of the image by inverting all pixel values. Each color channel value is subtracted from 255, resulting in opposite colors (e.g., white becomes black, red becomes cyan).
- [ImageNew()](functions/imagenew.md) - Creates a image.
- [ImageOverlay()](functions/imageoverlay.md) - Combines two images by overlaying one on top of the other using alpha compositing. The second image is blended with the first based on its transparency.
- [ImagePaste()](functions/imagepaste.md) - Composites one image onto another at specified coordinates. The second image is overlaid on top of the first image, preserving transparency and using high-quality interpolation.
- [ImageRead()](functions/imageread.md) - Reads the source pathname or URL and creates a image.
- [ImageReadBase64()](functions/imagereadbase64.md) - Creates a image from a Base64 string.
- [ImageResize()](functions/imageresize.md) - Resizes a image.
- [ImageRotate()](functions/imagerotate.md) - Rotates a image at a specified point by a specified angle.
- [ImageRotateDrawingAxis()](functions/imagerotatedrawingaxis.md) - Rotates all subsequent drawing on a image at a specified point by a specified angle.
- [ImageScaleToFit()](functions/imagescaletofit.md) - Creates a resized image with the aspect ratio maintained.
- [ImageSetAntialiasing()](functions/imagesetantialiasing.md) - Switches antialiasing on or off in rendered graphics.
- [ImageSetBackgroundColor()](functions/imagesetbackgroundcolor.md) - Sets the background color for the image. The background color is used for clearing a region. Setting the background color only affects the subsequent ImageClearRect calls
- [ImageSetDrawingAlpha()](functions/imagesetdrawingalpha.md) - Sets the current drawing alpha for images. All subsequent graphics operations use the specified alpha.
- [ImageSetDrawingColor()](functions/imagesetdrawingcolor.md) - Sets the current drawing color for images. All subsequent graphics operations use the specified color.
- [ImageSetDrawingStroke()](functions/imagesetdrawingstroke.md) - Sets the drawing stroke for points and lines in subsequent images.
- [ImageSetDrawingTransparency()](functions/imagesetdrawingtransparency.md) - Specifies the degree of transparency of drawing functions.
- [ImageSharpen()](functions/imagesharpen.md) - Enhances image clarity by applying an unsharp mask filter. 
This technique works by:
1. Creating a blurred copy of the original image
2. Finding edges by comparing differences
3. Enhancing edge contrast where differences are found
*Note:* Despite the name "unsharp mask", this process actually increases sharpness.
- [ImageShear()](functions/imageshear.md) - Transforms an image by shearing it along one axis, creating a slanted or skewed effect. Positive values slant in one direction, negative values in the opposite direction.
- [ImageShearDrawingAxis()](functions/imagesheardrawingaxis.md) - Shears the drawing canvas.
- [ImageTranslate()](functions/imagetranslate.md) - Moves an image to a new position by specified x and y offsets. The original image content is cleared and redrawn at the new location.
- [ImageTranslateDrawingAxis()](functions/imagetranslatedrawingaxis.md) - Translates the origin of the image context to the point (x,y) in the current coordinate system.
- [ImageWrite()](functions/imagewrite.md) - Writes a image to the specified filename or destination.
- [ImageWriteBase64()](functions/imagewritebase64.md) - Writes Base64 images to the specified filename and destination.
- [ImageWriteToBrowser()](functions/imagewritetobrowser.md) - Writes image to browser.
- [ImageXORDrawingMode()](functions/imagexordrawingmode.md) - Sets the paint mode of the image to alternate between the image's current color and the new specified color.
- [IncrementValue()](functions/incrementvalue.md) - this function is deprecated, use instead the ++ operator;Increments the current number by one
- [InputBaseN()](functions/inputbasen.md) - Converts string, using the base specified by radix, to an
integer. For example: #InputBaseN("3ff",16)#
- [inquiryaisession()](functions/inquiryaisession.md) - Sends a question/message to an AI session and returns the response. The function maintains conversation context from previous interactions within the same session.
The response can either be returned as a complete string or streamed in chunks to a listener function for real-time processing.
- [Insert()](functions/insert.md) - Inserts a substring in a string after a specified character
position. If position = 0, prefixes the substring to the
string.
- [InspectTemplates()](functions/inspecttemplates.md) - Flag all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool) to be checked once for any changes.
- [Int()](functions/int.md) - Calculates the closest integer that is smaller than number.
- [internalRequest()](functions/internalrequest.md) - Makes a request to the CFML Engine internally.
- [InterruptThread()](functions/interruptthread.md) - Interrupts a specified thread by setting its interrupt status flag.
This function sets the interrupt status flag on a CFThread. The behavior depends on the thread's current state:
- If the thread is blocked in a ThreadJoin or sleep method call: its interrupt status will be cleared and it will 
receive an InterruptedException
- If the thread is executing a long-running operation with interrupt checks: the operation may terminate early
- If the thread is not alive: the interrupt request may have no effect
- [Invoke()](functions/invoke.md) - invokes a function/operation of the given object and if given object is a string, Lucee tries to load as component.
- [IsArray()](functions/isarray.md) - Determines whether a value is an array.
- [IsBinary()](functions/isbinary.md) - Determines whether a value is stored as binary data.
- [IsBoolean()](functions/isboolean.md) - Determines if the object represents a boolean value
- [IsClosure()](functions/isclosure.md) - checks if given Object is a closure or not.
- [IsCustomFunction()](functions/iscustomfunction.md) - Determines whether a name represents a custom function
- [IsDate()](functions/isdate.md) - Determines whether a string or Java object can be converted
to a date/time value.
- [IsDebugMode()](functions/isdebugmode.md) - Determines whether debugging output is enabled.
- [IsDefined()](functions/isdefined.md) - Evaluates a string value to determine whether the variable
named in it exists.
- [IsEmpty()](functions/isempty.md) - Returns whether or not a given value is "empty".
- [IsFileObject()](functions/isfileobject.md) - Determines whether a value is an file object. True, if the value represents a file object.
- [isflushed()](functions/isflushed.md) - returns true if the response stream was already flushed.
- [IsImage()](functions/isimage.md) - Determines whether a variable returns a image.
- [IsImageFile()](functions/isimagefile.md) - Verifies whether an image file is valid.
- [IsInstanceOf()](functions/isinstanceof.md) - Determines whether an object is an instance of a Lucee interface or component, or of a Java class.
- [IsInThread()](functions/isinthread.md) - Determines whether the executing code is inside a cfthread or not.
- [IsIPInRange()](functions/isipinrange.md) - Checks if an ip is in the range of a list of given ips. IPv4 and IPv6 are supported.
- [IsIPv6()](functions/isipv6.md) - checks if given IP is of IPV6 format
- [IsJson()](functions/isjson.md) - Evaluates whether a string is in a valid JSON (JavaScript Object Notation) or JSON5 data interchange format.
- [IsLeapYear()](functions/isleapyear.md) - Determines whether a year is a leap year.
- [IsLocalHost()](functions/islocalhost.md) - Determines whether the specified IP address is the localhost.
- [IsNull()](functions/isnull.md) - Determines whether given object is null or not
- [IsNumeric()](functions/isnumeric.md) - Determines if the object represents a numeric
- [IsNumericDate()](functions/isnumericdate.md) - Evaluates whether a real number is a valid representation of a
date (date/time object).
- [IsObject()](functions/isobject.md) - Determines whether a value is an object.
- [IsPDFObject()](functions/ispdfobject.md) - Determines whether a value is a PDF object.
- [IsQuery()](functions/isquery.md) - Determines whether value is a query.
- [IsSimpleValue()](functions/issimplevalue.md) - Determines if the object represents a simple value like a string, number, boolean etc
- [IsSOAPRequest()](functions/issoaprequest.md) - Determines whether a CFC is being called as a web service.
- [IsStruct()](functions/isstruct.md) - Determines if the object is a structure
- [IsUserInAnyRole()](functions/isuserinanyrole.md) - Determines whether an authenticated user belongs to any role in a list of roles.
- [IsUserInRole()](functions/isuserinrole.md) - Determines whether an authenticated user belongs to the
specified Role.
- [IsUserLoggedIn()](functions/isuserloggedin.md) - Determines whether a user is logged in.
- [IsValid()](functions/isvalid.md) - Tests whether a value meets a validation or data type rule.
- [IsWddx()](functions/iswddx.md) - Determines whether a value is a well-formed WDDX packet.
- [IsWithinTransaction()](functions/iswithintransaction.md) - Determines whether the current thread is within a transaction block or not.
- [IsXML()](functions/isxml.md) - Determines whether a string is well-formed XML text.
- [IsXmlAttribute()](functions/isxmlattribute.md) - Determines whether the function parameter is an
XML Document Object Model (DOM) attribute node.
- [IsXmlDoc()](functions/isxmldoc.md) - Determines whether a function parameter is an Extended Markup
language (XML) document object.
- [IsXmlElem()](functions/isxmlelem.md) - Determines whether a function parameter is an Extended Markup
language (XML) document object element.
- [IsXmlNode()](functions/isxmlnode.md) - Determines whether the function parameter is
an XML document object node.
- [IsXmlRoot()](functions/isxmlroot.md) - Determines whether a function parameter is the root element of
an Extended Markup language (XML) document object.
- [IsZipFile()](functions/iszipfile.md) - Verifies whether an zip file is valid.
- [JavaCast()](functions/javacast.md) - Converts the data type of a CFML variable to pass as an
argument to an overloaded method of a Java object. Use only
for scalar and string arguments.
[type - quickly]
boolean,int,long,float,double,string
- [JSStringFormat()](functions/jsstringformat.md) - Escapes special JavaScript characters, such as single quotation
mark, double quotation mark, and newline
- [LCase()](functions/lcase.md) - Converts the alphabetic characters in a string to lowercase.
- [Left()](functions/left.md) - Returns a substring from beginning of the input string, with a length specified by the count argument.
- [Len()](functions/len.md) - Determines the length of a string, array or struct
- [ListAppend()](functions/listappend.md) - Concatenates a list or element to a list.
- [ListAvg()](functions/listavg.md) - Calculates average from all numeric values given in the list
- [ListChangeDelims()](functions/listchangedelims.md) - Changes a list delimiter.
Returns a copy of the list, with each delimiter character
replaced by new_delimiter.
- [ListCompact()](functions/listcompact.md) - Removes any empty items from the start and end of the list
- [ListContains()](functions/listcontains.md) - Determines the index of the first list element that contains a
specified substring.
Returns the index of the first list element that contains
substring. If not found, returns zero.
- [ListContainsNoCase()](functions/listcontainsnocase.md) - Determines the index of the first list element that contains a
specified substring.
- [ListDeleteAt()](functions/listdeleteat.md) - Deletes an element from a list.
Returns a copy of the list, without the specified element.
- [ListEach()](functions/listeach.md) - call the given UDF/Closure with every value in the string list.
- [ListEvery()](functions/listevery.md) - This function calls a given closure/function with every element in a given string list and returns true, if all of the closure calls returns true.
- [ListFilter()](functions/listfilter.md) - This function creates a new string list that returns all entries from an string list that match the given filter.
- [ListFind()](functions/listfind.md) - Determines the index of the first list element in which a
specified value occurs. Case-sensitive
- [ListFindNoCase()](functions/listfindnocase.md) - Determines the index of the first list element in which a
specified value occurs
- [ListFirst()](functions/listfirst.md) - Gets the first element of a list.
- [ListGetAt()](functions/listgetat.md) - Gets a list element at a specified position.
- [ListGetDuplicates()](functions/listgetduplicates.md) - Gets a list of duplicate values from a list.
- [ListIndexExists()](functions/listindexexists.md) - Determines if an element at the given position exists or not
- [ListInsertAt()](functions/listinsertat.md) - Inserts an element in a list.
- [ListItemTrim()](functions/listitemtrim.md) - Removes all the white space surrounding each element, returning back the new list
- [ListLast()](functions/listlast.md) - Gets the last element of a list.
- [ListLen()](functions/listlen.md) - Determines the number of elements in a list.
- [ListMap()](functions/listmap.md) - Calls the given closure with every element in the given list.
The function returns a list that contains all values returned by the closure.
- [ListPrepend()](functions/listprepend.md) - Inserts an element at the beginning of a list.
- [ListQualifiedToArray()](functions/listqualifiedtoarray.md) - Copies the elements of a list to an array.
- [ListQualify()](functions/listqualify.md) - Inserts a string at the beginning and end of list elements.
- [ListReduce()](functions/listreduce.md) - Iterates over every entry of the given list and calls the closure with every element. 
This function will reduce the list to a single value and will return the value.
- [ListRemoveDuplicates()](functions/listremoveduplicates.md) - Removes duplicate values from list.
- [ListRest()](functions/listrest.md) - Gets a list, without its first element.
- [ListSetAt()](functions/listsetat.md) - Replaces the contents of a list element.
- [ListSome()](functions/listsome.md) - This function calls a given closure/function with every element in a given string list and returns true, if one of the closure calls returns true.
- [ListSort()](functions/listsort.md) - Sorts list elements according to a sort type and sort order.
- [ListToArray()](functions/listtoarray.md) - Copies the elements of a list to an array.
- [ListTrim()](functions/listtrim.md) - this function is deprecated, use instead ListCompact
- [ListValueCount()](functions/listvaluecount.md) - Counts instances of a specified value in a list. The search is
case-sensitive.
- [ListValueCountNoCase()](functions/listvaluecountnocase.md) - Counts instances of a specified value in a list. The search is
case-insensitive.
- [LJustify()](functions/ljustify.md) - Left justifies characters in a string of a specified length.
- [LoadAISession()](functions/loadaisession.md) - Restores an AI session from a serialized JSON string or struct. This function recreates an AI session with:
- Original configuration settings (temperature, limits, timeouts)
- Complete conversation history
- System message prompt
The function supports loading sessions by:
- AI engine name
- Engine ID (using `id:` prefix)
- Default engine (using `default:` prefix)
This function pairs with `SerializeAISession()` to provide persistence for AI conversations across requests or application restarts.
- [Location()](functions/location.md) - Stops execution of the current request and redirect to another location.
- [Log()](functions/log.md) - Calculates the natural logarithm of a number. Natural
logarithms are based on the constant e (2.71828182845904).
- [Log10()](functions/log10.md) - Calculates the logarithm of number, to base 10.
- [LogAllThreads()](functions/logallthreads.md) - Creates detailed thread stack trace logs in JSONL format for performance analysis and debugging.
This function captures stack traces from all running threads at specified intervals for a given duration.
It executes asynchronously, returning immediately after starting the logging process, making it ideal
for analyzing specific code segments by initiating logging just before the target code execution.
The output format is JSONL (JSON Lines), where each line represents a separate JSON object containing:
- Timestamp offset in milliseconds from 1/1/1970 00:00:00 UTC (Unix 0)
- Complete stack trace of each thread's current location
This data can be used for:
- Performance bottleneck identification
- Thread behavior analysis
- Deadlock detection
- Resource usage patterns
- [LSCurrencyFormat()](functions/lscurrencyformat.md) - Formats a number in a locale-specific currency format.
- [LSDateFormat()](functions/lsdateformat.md) - Formats a date string to a given output using the current sessions locale
- [LSDateTimeFormat()](functions/lsdatetimeformat.md) - Formats a date string to a given output using the current locale
- [LSDayOfWeek()](functions/lsdayofweek.md) - Returns the day of the week the date represents in locale format
- [LSEuroCurrencyFormat()](functions/lseurocurrencyformat.md) - this function is just an alias for lsCurrencyFormat
- [LSIsCurrency()](functions/lsiscurrency.md) - Determines whether a string is a valid representation of a
currency amount in the current locale.
- [LSIsDate()](functions/lsisdate.md) - Determines whether a string is a valid representation of a
date/time value in the current locale.
- [LSIsNumeric()](functions/lsisnumeric.md) - Determines whether a string is a valid representation of a
number in the current locale.
- [LSLCase()](functions/lslcase.md) - Converts the alphabetic characters in a specified string to lowercase, respecting locale-specific casing rules. This is particularly important for languages where the standard lowercase conversion rules do not apply, ensuring accurate and culturally correct text processing. The function defaults to the current page's locale if no locale is specified.
- [LSNumberFormat()](functions/lsnumberformat.md) - Formats a number to the given format mask in the current locale
- [LSParseCurrency()](functions/lsparsecurrency.md) - Converts a locale-specific currency string into a formatted
number. Attempts conversion by comparing the string with each
the three supported currency formats (none, local,
international) and using the first that matches.
- [LSParseDateTime()](functions/lsparsedatetime.md) - Converts a string that is a valid date/time representation in
the current locale into a date/time object.
- [LSParseEuroCurrency()](functions/lsparseeurocurrency.md) - use function lsParseCurrency instead
- [LSParseNumber()](functions/lsparsenumber.md) - Converts a string that is a valid numeric representation in
the current locale into a formatted number.
- [LSTimeFormat()](functions/lstimeformat.md) - Formats a time string to a given output using the current locale.
- [LSUCase()](functions/lsucase.md) - Converts the alphabetic characters in a specified string to uppercase, respecting locale-specific casing rules
- [LsWeek()](functions/lsweek.md) - Returns the week number in the year of the date referenced, based on the local influence.
- [LTrim()](functions/ltrim.md) - Removes leading spaces from a string.
- [LuceeAIgetMetadata()](functions/luceeaigetmetadata.md) - Retrieves metadata about a configured AI endpoint. 
Returns information about the endpoint's configuration, 
and optionally detailed information about available models and associated files.
- [LuceeAIhas()](functions/luceeaihas.md) - Checks whether a specific AI endpoint is configured and available for use.
- [LuceeCreateAIsession()](functions/luceecreateaisession.md) - Creates a new AI session for interaction with Large Language Models (LLMs). 
The session maintains conversation history and context between interactions. 
Each session can be configured with different parameters to optimize for specific use cases like code analysis, content generation, or data processing.
Common usage patterns:
- Exception analysis and debugging assistance
- Code documentation generation
- Query optimization suggestions
- Security review assistance
- Performance optimization recommendations
The session persists until explicitly terminated or the application restarts.
- [LuceeInquiryAIsession()](functions/luceeinquiryaisession.md) - Sends a question/message to an AI session and returns the response. The function maintains conversation context from previous interactions within the same session.
The response can either be returned as a complete string or streamed in chunks to a listener function for real-time processing.
- [ManifestRead()](functions/manifestread.md) - reads a manifest file and returns the content as struct
- [MarkdownToHtml()](functions/markdowntohtml.md) - Transforms Markdown formatted String into HTML.
- [MavenInfo()](functions/maveninfo.md) - Retrieves information about a Maven artifact and its dependencies.
This function allows you to query details about a specific Maven artifact by providing its coordinates (groupId, artifactId, and optionally version). 
It returns a query containing information about the artifact itself and all of its dependencies based on the specified scope.
The returned query includes columns for:
- **groupId**: The group identifier of the artifact
- **artifactId**: The artifact identifier
- **version**: The version of the artifact
- **scope**: The scope of the dependency (compile, provided, runtime, test, system)
- **optional**: Whether the dependency is optional
- **checksum**: Checksum information
- **url**: URL where the artifact can be found
- **path**: Local file path to the artifact
This function is useful for debugging classloading issues, understanding dependency trees, or gathering information about the libraries your application depends on.
- [MavenLoad()](functions/mavenload.md) - Loads all JAR files from one or more Maven endpoints and makes them available for use within the Lucee server environment. 
This function can be used to load dependencies, including transitive ones, for example at server startup.
### Example Usage of MavenLoad Function
The `MavenLoad` function allows you to load JAR files from Maven repositories, including all transitive dependencies. 
This is particularly useful during server startup to ensure that all required libraries are available.
#### Example Input as an Array of Structs:
```cfml
mavenLoad([
{
"groupId": "org.slf4j",
"artifactId": "slf4j-api",
"version": "1.7.32"
}
]);
```
- [Max()](functions/max.md) - Determines the greater of two numbers.
- [Metaphone()](functions/metaphone.md) - Metaphone is a phonetic algorithm, an algorithm published in 1990 for indexing words by their English pronunciation. The algorithm produces variable length keys as its output, as opposed to Soundex's fixed-length keys. Similar sounding words share the same keys.
- [Mid()](functions/mid.md) - Extracts a substring from a string.
- [Millisecond()](functions/millisecond.md) - Returns the milliseconds of the referenced date
- [Min()](functions/min.md) - Determines the lesser of two numbers.
- [Minute()](functions/minute.md) - Extracts the minute value from a date/time object.
- [Month()](functions/month.md) - Extracts the month value from a date/time object.
- [MonthAsString()](functions/monthasstring.md) - Returns the string label for the given month
- [MonthShortAsString()](functions/monthshortasstring.md) - Returns the string label for the given month in short format
- [NewLine()](functions/newline.md) - returns a new line
- [Now()](functions/now.md) - Returns the current date and time
- [NowServer()](functions/nowserver.md) - this function is deprecated, returns the current time on the server independent on lucee timezone definition
- [NullValue()](functions/nullvalue.md) - returns null
- [NumberFormat()](functions/numberformat.md) - Creates a custom-formatted number value
- [ObjectEquals()](functions/objectequals.md) - compares simply and complex objects for equality, by default, string comparison is not case sensitive
- [ObjectLoad()](functions/objectload.md) - loads an object serialized in a binary form from a file or as binary input
- [ObjectSave()](functions/objectsave.md) - serialize a (Serializable) object to a binary representation of the object
- [ORMClearSession()](functions/ormclearsession.md) - Removes all the entities that are loaded or created in the session.
- [ORMCloseAllSessions()](functions/ormcloseallsessions.md) - Closes all ORM session.
- [ORMCloseSession()](functions/ormclosesession.md) - Closes the current ORM session.
- [ORMEvictCollection()](functions/ormevictcollection.md) - This will remove all the entries with the specified relation/collection name in the specified component.
- [ORMEvictEntity()](functions/ormevictentity.md) - This will remove all the entries for the specified component name from the entity cache.
- [ORMEvictQueries()](functions/ormevictqueries.md) - This will remove all the queries from the named query cache.
- [ORMExecuteQuery()](functions/ormexecutequery.md) - Runs the HQL on the default data source specified for the application.
- [ORMFlush()](functions/ormflush.md) - Flushes the current ORM session.
- [ORMGetSession()](functions/ormgetsession.md) - Returns the current ORM session
- [ORMGetSessionFactory()](functions/ormgetsessionfactory.md) - Returns ORM session factory instance
- [ORMReload()](functions/ormreload.md) - Returns ORM session factory instance
- [PagePoolClear()](functions/pagepoolclear.md) - Clear out all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool)
- [PagePoolList()](functions/pagepoollist.md) - Lists all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool)
- [ParagraphFormat()](functions/paragraphformat.md) - Formats the carriage returns in a string to a HTML alternatives
- [ParameterExists()](functions/parameterexists.md) - Determines if the parameter exists
- [ParseDateTime()](functions/parsedatetime.md) - Parses a date/time string according to the English (U.S.) locale conventions.
- [ParseNumber()](functions/parsenumber.md) - Parses the string argument as a numeric value.
- [Pi()](functions/pi.md) - Gets the mathematical constant p, accurate to 15 digits.
The number 3.14159265358979.
- [PrecisionEvaluate()](functions/precisionevaluate.md) - Evaluates one or more string expressions.
- [PreserveSingleQuotes()](functions/preservesinglequotes.md) - Returns back string without letting the engine escape the single quotes. Used within CFQUERY blocks usually
- [Quarter()](functions/quarter.md) - Calculates the quarter of the year in which a date falls.
- [Query()](functions/query.md) - Create and populate a query object in the form query(columnName1:[1,2,3],columnName2:[4,5,6])
- [QueryAddColumn()](functions/queryaddcolumn.md) - Adds a column to a query and populates its rows with the
contents of a one-dimensional array. Pads query columns,
if necessary, to ensure that all columns have the same number
of rows.
- [QueryAddRow()](functions/queryaddrow.md) - Adds rows to a query, either empty row(s) or you can add a row with data
- [QueryAppend()](functions/queryappend.md) - Adds all values of one query to the end of another query. Both queries need to have the same columns.
- [QueryClear()](functions/queryclear.md) - Clears all rows from a query
- [QueryClose()](functions/queryclose.md) - When using lazy="true", it is important to close the resultSet during a request or it will continue to use heap memory.
- [QueryColumnArray()](functions/querycolumnarray.md) - return the column names as array
- [QueryColumnCount()](functions/querycolumncount.md) - column count of given query
- [QueryColumnData()](functions/querycolumndata.md) - Returns all the data in a query for a given column
- [QueryColumnExists()](functions/querycolumnexists.md) - Determines whether a specific column is present in a query.
- [QueryColumnList()](functions/querycolumnlist.md) - return the column names as list
- [QueryConvertForGrid()](functions/queryconvertforgrid.md) - Use instead the function QuerySlice.
- [QueryCurrentRow()](functions/querycurrentrow.md) - return the row where the pointer of the query is pointing ATM
- [QueryDeleteColumn()](functions/querydeletecolumn.md) - removes a row from a query and return removed row as array
- [QueryDeleteRow()](functions/querydeleterow.md) - Deletes the row within a query object. Modifies the original query object
- [QueryEach()](functions/queryeach.md) - call the given UDF/Closure with every row (struct) in the query.
- [QueryEvery()](functions/queryevery.md) - This function calls a given closure/function with every element in a given query and returns true, if all of the closure calls returns true.
- [QueryExecute()](functions/queryexecute.md) - Executes a SQL query, returns the result.
- [QueryFilter()](functions/queryfilter.md) - This function creates a new Query that returns all rows from an query that match the given filter.
- [QueryGetCell()](functions/querygetcell.md) - return the value of a specific query cell
- [QueryGetCellByIndex()](functions/querygetcellbyindex.md) - return the value of a specific query cell
- [QueryGetRow()](functions/querygetrow.md) - this function is deprecated, use function QueryRowData instead.
- [QueryInsertAt()](functions/queryinsertat.md) - Adds data (query,struct or array) into query.
- [QueryIsEmpty()](functions/queryisempty.md) - returns query empty or not
- [QueryKeyExists()](functions/querykeyexists.md) - Determines whether a specific column is present in a query.
- [QueryLazy()](functions/querylazy.md) - Executes a SQL query without loading the data entirely to memory. Instead it calls the given Function with every single row
- [QueryMap()](functions/querymap.md) - Calls the given closure with every row in the query.
- [QueryNew()](functions/querynew.md) - Creates an empty query (query object).
- [QueryPrepend()](functions/queryprepend.md) - Adds all values of one query the begin to another query. Both queries need to have the same columns.
- [QueryRecordCount()](functions/queryrecordcount.md) - row count of given query
- [QueryReduce()](functions/queryreduce.md) - Iterates over every row of the given query and calls the closure with that row. 
This function will reduce the query to a single value and will return this value.
- [QueryRenameColumn()](functions/queryrenamecolumn.md) - Rename a column
- [QueryReverse()](functions/queryreverse.md) - reverse the row order of a complete query
- [QueryRowByIndex()](functions/queryrowbyindex.md) - 
- [QueryRowData()](functions/queryrowdata.md) - Returns a struct with the data from a query for a given row number
- [QueryRowDataByIndex()](functions/queryrowdatabyindex.md) - 
- [QueryRowSwap()](functions/queryrowswap.md) - swaps one row of a query with an other.
- [QuerySetCell()](functions/querysetcell.md) - Sets a cell to a value. If no row number is specified, the cell on the last row is set.
- [QuerySetRow()](functions/querysetrow.md) - Adds a row to a query, either by struct or array
- [QuerySlice()](functions/queryslice.md) - creates a new query containing a part of the given query
- [QuerySome()](functions/querysome.md) - This function calls a given closure/function with every element in a given query and returns true, if one of the closure calls returns true.
- [QuerySort()](functions/querysort.md) - Sorts the query based on the column specified and the order criteria given. Modifies the original query object
- [QueryToStruct()](functions/querytostruct.md) - Copy the query columns data to struct by using the columnKey argument
- [QuotedValueList()](functions/quotedvaluelist.md) - Returns a quoted list of all the values, for a given column within the query, delimited by the value given.
this function is deprecated, use instead the function queryColumnData
- [Rand()](functions/rand.md) - Generates a pseudo-random number in the range 0 - 1.
- [Randomize()](functions/randomize.md) - Seeds the pseudo-random number generator with an
integer number, ensuring repeatable number patterns.
- [RandRange()](functions/randrange.md) - Generates a random integer between two specified numbers.
- [RedisCommand()](functions/rediscommand.md) - execute any redis function without any interpretation from Lucee.
- [RedisCommandLowPriority()](functions/rediscommandlowpriority.md) - This function works the same way as RedisCommand with only one difference. In case the connection pool is down to one free connection. The thread will wait for at least one connection more get free. So this command will not use the last connection available.
- [RedisConnectionPoolInfo()](functions/redisconnectionpoolinfo.md) - Gives back detailed information about the Redis connection pool.
- [REEscape()](functions/reescape.md) - Escapes regular expression control characters within a string.
- [REFind()](functions/refind.md) - Uses a regular expression (RE) to search a string for a pattern. The search is case sensitive.
- [REFindNoCase()](functions/refindnocase.md) - Uses a regular expression (RE) to search a string for a pattern,
starting from a specified position. The search is
case-insensitive.
- [ReleaseComObject()](functions/releasecomobject.md) - Releases a COM Object and frees up resources that it used.
- [REMatch()](functions/rematch.md) - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- [REMatchNoCase()](functions/rematchnocase.md) - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- [RemoveChars()](functions/removechars.md) - Removes characters from a string.
- [Render()](functions/render.md) - Similar to the Evaluate() function, this function executes Lucee tag code that you provide as a string and returns any output as a string.
- [RepeatString()](functions/repeatstring.md) - Creates a string that contains a specified number of
repetitions of the specified string.
- [Replace()](functions/replace.md) - Replaces occurrences of substring1 in a string with substring2,
in a specified scope. The search is case-sensitive.
- [ReplaceList()](functions/replacelist.md) - Replaces occurrences of the elements from a delimited list
in a string with corresponding elements from another delimited
list. The search is case-sensitive.
- [ReplaceListNoCase()](functions/replacelistnocase.md) - Replaces occurrences of the elements from a delimited list
in a string with corresponding elements from another delimited
list. The search is NOT case-sensitive.
- [ReplaceNoCase()](functions/replacenocase.md) - Replaces occurrences of substring1 with substring2, in the
specified scope. The search is case-insensitive.
- [REReplace()](functions/rereplace.md) - Uses a regular expression (RE) to search a string for a string
pattern and replace it with another. The search is
case-sensitive.
- [REReplaceNoCase()](functions/rereplacenocase.md) - Uses a regular expression to search a string for a string
pattern and replace it with another. The search is
case-insensitive.
- [RestDeleteApplication()](functions/restdeleteapplication.md) - Deletes an existing REST mapping.
- [RestInitApplication()](functions/restinitapplication.md) - Registers the directory path with the service mapping provided.
- [RestSetResponse()](functions/restsetresponse.md) - Sets the custom responses.
- [Reverse()](functions/reverse.md) - Reverses the order of items, such as the characters in a
string, the digits in a number, or the elements in an array.
- [Right()](functions/right.md) - Returns a substring from end of the input string, with a length specified by the count argument.
- [RJustify()](functions/rjustify.md) - Right justifies characters of a string.
- [Round()](functions/round.md) - Rounds a number to the closest integer.
- [RTrim()](functions/rtrim.md) - Removes spaces from the end of a string.
- [RunAsync()](functions/runasync.md) - A function that returns a Future object, which is an eventual result of an asynchronous operation
- [s3addacl()](functions/s3addacl.md) - Adds ACL to existing ACL for object or bucket. You can provide the endpoint as a bucket/object definition (S3AddACL(bucket:"mybucket",object:"myobject.txt",acl:data) ) or as a virtual filesystem path (S3AddACL(path:"s3://mybucket/myobject.txt",acl:data) ).
- [s3clearBucket()](functions/s3clearbucket.md) - Removes all objects from a bucket, unless maxage is set, in that case only objects that are older than maxage are removed.
- [s3copy()](functions/s3copy.md) - Copies an object in S3 from one bucket to an other.
- [s3createbucket()](functions/s3createbucket.md) - Creates a bucket on S3.
- [s3delete()](functions/s3delete.md) - deletes a bucket or an object within a bucket.
- [s3deletebucket()](functions/s3deletebucket.md) - deletes a bucket, this function is deprecated, use instead S3Delete.
- [s3download()](functions/s3download.md) - Downloads an object from an S3 bucket. 
It can save the object to a specified path, return its content directly, or process the content in parts through a provided closure or UDF (User-Defined Function).
- [s3exists()](functions/s3exists.md) - Checks if given object exists in
- [s3generatePresignedUrl()](functions/s3generatepresignedurl.md) - Generates a presigned URL pointing to the object given. You can provide the endpoint as a bucket/object definition (S3AddACL(bucket:"mybucket",object:"myobject.txt") ) or as a virtual filesystem path (S3AddACL(path:"s3://mybucket/myobject.txt") ).
- [s3generateuri()](functions/s3generateuri.md) - Generates a URI endpoint pointing to the object given. You can provide the endpoint as a bucket/object definition (S3AddACL(bucket:"mybucket",object:"myobject.txt") ) or as a virtual filesystem path (S3AddACL(path:"s3://mybucket/myobject.txt") ).
- [s3getacl()](functions/s3getacl.md) - Returns an array of structures, with each structure representing an ACL (Access Control List) grant. You can provide the endpoint as a bucket/object definition (S3GetACL(bucket:"mybucket",object:"myobject.txt") ) or as a virtual filesystem path (S3GetACL(path:"s3://mybucket/myobject.txt") ).
- [s3getmetadata()](functions/s3getmetadata.md) - Returns the metadata related to the object or bucket. You can provide the endpoint as a bucket/object definition (S3GetMetaData(bucket:"mybucket",object:"myobject.txt") ) or as a virtual filesystem path (S3GetMetaData(path:"s3://mybucket/myobject.txt") ).
- [s3getversioninfo()](functions/s3getversioninfo.md) - Returns version information as a query for a specific object or bucket.
- [s3listBucket()](functions/s3listbucket.md) - List all objects in a bucket
- [s3listbuckets()](functions/s3listbuckets.md) - List all buckets
- [s3move()](functions/s3move.md) - Moves an object in S3 from one bucket to an other.
- [s3read()](functions/s3read.md) - Reads an object from S3 as a string.
- [s3readBinary()](functions/s3readbinary.md) - Reads an object from S3 as a binary.
- [s3setacl()](functions/s3setacl.md) - Sets ACL to existing ACL for object or bucket. You can provide the endpoint as a bucket/object definition (S3SetACL(bucket:"mybucket",object:"myobject.txt",acl:data) ) or as a virtual filesystem path (S3SetACL(path:"s3://mybucket/myobject.txt",acl:data) ).
- [s3setmetadata()](functions/s3setmetadata.md) - Sets the metadata on bucket or object. You can provide the endpoint as a bucket/object definition (S3SetMetaData(bucket:"mybucket",object:"myobject.txt",metadata:data) ) or as a virtual filesystem path (S3SetMetaData(path:"s3://mybucket/myobject.txt",metadata:data) ).
- [s3upload()](functions/s3upload.md) - Uploads a file to S3.
- [s3write()](functions/s3write.md) - Writes a value to S3.
- [Sanitize()](functions/sanitize.md) - Detects and masks sensitive information (such as passwords, API keys, tokens, etc.) from a given string. 
The function identifies patterns commonly used for sensitive data and replaces them with a mask.
- [SanitizeHtml()](functions/sanitizehtml.md) - Sanitizes unsafe HTML input and removes elements and attributes like JavaScript, onclick, etc.
See also https://github.com/OWASP/java-html-sanitizer
- [Second()](functions/second.md) - Extracts the ordinal for the second from a date/time object.
- [SecretProviderGet()](functions/secretproviderget.md) - Returns a reference to a secret value stored in a configured Secret Provider. The function doesn't immediately return the actual value, but rather a value object that can be handled by Lucee like a simple value.
This reference is automatically resolved to its actual value when:
- It's converted to a real simple value (string, boolean, number, date)
- It's used in operations requiring a simple value
When used, the function automatically validates that the secret exists and throws an exception if not found.
- [SendGatewayMessage()](functions/sendgatewaymessage.md) - Sends an outgoing message through an event gateway.
- [Serialize()](functions/serialize.md) - opposite of evaluate, this function serialize all cfml object and all serializable Java objects. can also serialize Components.
- [SerializeAISession()](functions/serializeaisession.md) - Serializes an AI session to a JSON string that includes its configuration and conversation history. The serialized content includes:
- Configuration settings (temperature, limits, timeouts, system message)
- Complete conversation history with questions and answers
This function is useful for:
- Persisting AI sessions
- Debugging AI conversations
- Sharing or transferring AI session data
- Storing AI conversation history
Use `LoadAISession()` to restore a serialized session.
- [SerializeJSON()](functions/serializejson.md) - Converts CFML data into a JSON (JavaScript Object Notation) representation of the data.
- [SessionCommit()](functions/sessioncommit.md) - Force saving the session to storage, useful when sessionCluster is enabled.
- [SessionExists()](functions/sessionexists.md) - Returns a boolean indicating if a session has been already created / exists.
- [SessionInvalidate()](functions/sessioninvalidate.md) - Invalidates or cleans up the current session.
- [SessionRotate()](functions/sessionrotate.md) - invalidate current session, creates a new session and migrate the data from the old session to the new.
- [SessionStartTime()](functions/sessionstarttime.md) - Provides information about the time when the current users session scope was created.
- [SetEncoding()](functions/setencoding.md) - Sets the character encoding (character set) of Form and URL
scope variable values; used when the character encoding of
the input to a form, or the character encoding of a URL, is
not in UTF-8 encoding.
- [SetLocale()](functions/setlocale.md) - Sets the country/language locale for CFML processing and the page returned to the client.
- [SetProfileString()](functions/setprofilestring.md) - Sets the value of a profile entry in an initialization file.
- [SetPropertyString()](functions/setpropertystring.md) - Sets the value of a property entry in a properties file.
- [SetTimeZone()](functions/settimezone.md) - change the timezone definition for the current request.
- [SetVariable()](functions/setvariable.md) - Sets the value
- [Sgn()](functions/sgn.md) - Determines the sign of a number.
- [Sin()](functions/sin.md) - Calculates the sine of an angle that is entered in radians.
- [SizeOf()](functions/sizeof.md) - this function is experimental, do not use in a production environment. this function returns the size in bytes of a given object.
- [Sleep()](functions/sleep.md) - Causes the current thread to stop processing for a specified period of time.
- [Soundex()](functions/soundex.md) - Soundex is a phonetic algorithm for indexing names by sound, as pronounced in English. The goal is for homophones to be encoded to the same representation so that they can be matched despite minor differences in spelling. The algorithm mainly encodes consonants; a vowel will not be encoded unless it is the first letter. Soundex is the most widely known of all phonetic algorithms, as it is a standard feature of MS SQL and Oracle, and is often used (incorrectly) as a synonym for "phonetic algorithm".
- [SpanExcluding()](functions/spanexcluding.md) - Gets characters from a string, from the beginning to a
character that is in a specified set of characters. The
search is case-sensitive.
- [SpanIncluding()](functions/spanincluding.md) - Gets characters from a string, from the beginning to a
character that is not in a specified set of characters. The
search is case-sensitive.
- [SpreadSheetNew](functions/spreadsheetnew.md) - 
- [Sqr()](functions/sqr.md) - Calculates the square root of a number.
- [SSLCertificateInstall()](functions/sslcertificateinstall.md) - install certificates of a specific host
- [SSLCertificateList()](functions/sslcertificatelist.md) - Returns a list of SSL certificates. If a host is specified, it lists the certificates available for that specific host. If no host is specified, it lists all certificates stored in the KeyStore.
- [StoreAddACL()](functions/storeaddacl.md) - Adds ACL to existing ACL for object or bucket. This function operates identically to "S3AddACL", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreGetACL()](functions/storegetacl.md) - Returns an array of structures, with each structure representing an ACL (Access Control List) grant. This function operates identically to "S3GetACL", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreGetMetadata()](functions/storegetmetadata.md) - Returns the metadata related to the object or bucket. This function operates identically to "S3GetMetaData", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreSetACL()](functions/storesetacl.md) - Sets the ACL for object or bucket. This function operates identically to "S3SetACL", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreSetMetadata()](functions/storesetmetadata.md) - Sets the metadata on bucket or object. This function operates identically to "S3SetMetaData", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StringEach()](functions/stringeach.md) - Iterates over a string and runs the closure function for each element in the string.
- [StringEvery()](functions/stringevery.md) - Determines if all elements of a string satisfy a given condition.
- [StringFilter()](functions/stringfilter.md) - Filters a string to its elements for which the callback function returns true.
- [StringLen()](functions/stringlen.md) - returns the len of a string
- [StringMap()](functions/stringmap.md) - Iterates over every entry of the string and calls the closure function to work on the element of the string.
- [StringReduce()](functions/stringreduce.md) - Iterates over every element of the string and calls the closure to work on the elements of the string. This function will reduce the string to a single value and will return the value.
- [StringSome()](functions/stringsome.md) - This function calls a given closure/function with every element in a given string and returns true, if one of the closure calls returns true.
- [StringSort()](functions/stringsort.md) - Returns a string containing the sorted characters from the input.
- [StripCr()](functions/stripcr.md) - Deletes return characters from a string.
- [StructAppend()](functions/structappend.md) - Appends all the data from struct2 into struct2, replacing duplicate keys unless specified by the overwrite flag
- [StructClear()](functions/structclear.md) - Removes all data from a structure.
- [StructCopy()](functions/structcopy.md) - Copies a structure. Copies top-level keys, values, and arrays
in the structure by value; copies nested structures by
reference.
- [StructCount()](functions/structcount.md) - Counts the keys in a structure.
- [StructDelete()](functions/structdelete.md) - Removes an element from a structure.
- [StructEach()](functions/structeach.md) - call the given UDF/Closure with every entry (key/value) in the struct.
- [StructEvery()](functions/structevery.md) - This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.
- [StructFilter()](functions/structfilter.md) - This function creates a new Struct that returns all entries from an struct that match the given filter.
- [StructFind()](functions/structfind.md) - Determines the value associated with a key in a structure.
- [StructFindKey()](functions/structfindkey.md) - Searches recursively through a substructure of nested arrays,
structures, and other elements, for structures whose values
match the search key in the value parameter.
- [StructFindValue()](functions/structfindvalue.md) - Searches recursively through a substructure of nested arrays,
structures, and other elements for structures with values that
match the search key in the value parameter.
- [StructGet()](functions/structget.md) - Gets a structure(s) from a specified path.
- [StructInsert()](functions/structinsert.md) - Inserts a key-value pair into a structure.
- [StructIsEmpty()](functions/structisempty.md) - Determines whether a structure contains data.
- [StructKeyArray()](functions/structkeyarray.md) - Returns an array of the keys from a structure
- [StructKeyExists()](functions/structkeyexists.md) - Determines whether a specific key is present in a structure.
- [StructKeyList()](functions/structkeylist.md) - Extracts keys from a struct.
- [StructKeyTranslate()](functions/structkeytranslate.md) - Converts any struct keys with dot notation into nested structures
- [StructMap()](functions/structmap.md) - Calls the given closure with every element in the given struct.
the function returns a struct that contains all values returned by the closure.
- [StructNew()](functions/structnew.md) - Creates an empty structure.
- [StructReduce()](functions/structreduce.md) - Iterates over every entry of the given struct and calls the closure with every key/value. 
This function will reduce the struct to a single value and will return this value.
- [StructSome()](functions/structsome.md) - This function calls a closure/function on every element in a struct until one returns true.
- [StructSort()](functions/structsort.md) - Returns a sorted array of the top level keys in a structure.
Sorts using alphabetic or numeric sorting, and can sort based
on the values of any structure element.
- [StructToSorted()](functions/structtosorted.md) - Returns a struct sorted by the top level keys in a structure.
Sorts using alphabetic or numeric sorting.
- [StructUpdate()](functions/structupdate.md) - Updates a key with a value.
- [StructValueArray()](functions/structvaluearray.md) - Returns an Array with the values of the Struct
- [SystemCacheClear()](functions/systemcacheclear.md) - clears all caches or the specified cache
- [SystemOutput()](functions/systemoutput.md) - writes the given string to the output stream.
- [Tan()](functions/tan.md) - Calculates the tangent of an angle that is entered in radians.
- [ThreadData()](functions/threaddata.md) - returns the root cfthread scope.
- [ThreadInterrupt()](functions/threadinterrupt.md) - Interrupts a specified thread by setting its interrupt status flag.
This function sets the interrupt status flag on a CFThread. The behavior depends on the thread's current state:
- If the thread is blocked in a ThreadJoin or sleep method call: its interrupt status will be cleared and it will 
receive an InterruptedException
- If the thread is executing a long-running operation with interrupt checks: the operation may terminate early
- If the thread is not alive: the interrupt request may have no effect
- [ThreadJoin()](functions/threadjoin.md) - Makes the current thread wait until the thread or threads specified in the name attribute complete processing, 
or until the period specified in the timeout argument passes, before continuing processing. If you don't specify a timeout and thread you are joining
to doesn't finish, the current thread also cannot finish processing.
- [ThreadTerminate()](functions/threadterminate.md) - Stops processing of the thread specified in the name attribute.
- [Throw()](functions/throw.md) - Throws a developer-specified exception, which can be caught with a cfcatch tag
- Application
Do not enter another predefined type; types are not generated by CFML applications. If you specify Application, you need not specify a type for cfcatch.
- [TimeFormat()](functions/timeformat.md) - Formats a time string to a given output
- [ToBase64()](functions/tobase64.md) - Calculates the Base64 representation of a string or binary object.
- [ToBinary()](functions/tobinary.md) - Calculates the binary representation of Base64-encoded data.
- [ToNumeric()](functions/tonumeric.md) - Converts given value to a number
- [ToScript()](functions/toscript.md) - Creates a JavaScript expression that assigns the value of a variable to a JavaScript variable. 
This function can convert strings, numbers, arrays, structures, and queries to JavaScript syntax that defines equivalent variables and values.
- [ToString()](functions/tostring.md) - Converts a value to a string.
- [Trace()](functions/trace.md) - Displays and logs debugging data about the state of an application at the time this function executes.
- [TransactionCommit()](functions/transactioncommit.md) - commits a pending transaction
- [TransactionRollback()](functions/transactionrollback.md) - rolls back a pending transaction
- [TransactionSetSavePoint()](functions/transactionsetsavepoint.md) - Saves a specific state within a transaction
- [Trim()](functions/trim.md) - Removes leading and trailing spaces from a string.
- [TrimWhitespace()](functions/trimwhitespace.md) - clean white space of the given string
- [TrueFalseFormat()](functions/truefalseformat.md) - True, for a non-zero value; False, otherwise.
- [UCase()](functions/ucase.md) - Converts the alphabetic characters in a string to uppercase.
- [UcFirst()](functions/ucfirst.md) - Capitalizes the first character of the given string.
- [UnserializeJava()](functions/unserializejava.md) - literal definition of a serialized Java Object by function serialize
- [URLDecode()](functions/urldecode.md) - Decodes a URL-encoded string, converting encoded characters back to their original form. 
This function handles URL encoding conventions such as converting plus signs (`+`) to spaces and percent-encoded sequences (`%xx`) to their corresponding characters.
The function throws an exception when encountering malformed URL encodings (such as incomplete or invalid percent sequences like `%G`). 
For optimal results, ensure the input string contains valid URL encoding.
- [URLEncode()](functions/urlencode.md) - Encodes a string to be URL-safe according to the application/x-www-form-urlencoded MIME format
- [URLEncodedFormat()](functions/urlencodedformat.md) - Generates a URL-encoded string. For example, it replaces spaces
with %20, and non-alphanumeric characters with equivalent
hexadecimal escape sequences. Passes arbitrary strings within a
URL.
- [URLSessionFormat()](functions/urlsessionformat.md) - Encodes the URL with the CFTOKEN/CFID/JSESSIONID
- [Val()](functions/val.md) - Converts numeric characters that occur at the beginning of a string to an number.
- [ValidateJson()](functions/validatejson.md) - validate a json string
- [ValueArray()](functions/valuearray.md) - Returns an array of all the values, for a given column within the query.
this function is deprecated, use instead the function queryColumnData
- [ValueList()](functions/valuelist.md) - Returns a list of all the values, for a given column within the query, delimited by the value given.
this function is deprecated, use instead the function queryColumnData
- [ValueRef()](functions/valueref.md) - creates a reference to a UDF that acts like a simple value.
- [WebserviceNew()](functions/webservicenew.md) - create a Webservice Proxy object, a reference to a remote webservice
- [WebSocketInfo()](functions/websocketinfo.md) - This funcitons give me information about the current websocket server instance.
- [Week()](functions/week.md) - From a date/time object, determines the week number within
the year. An integer in the range 1-53; the ordinal of the
week, within the year.
- [Wrap()](functions/wrap.md) - Wraps text so that each line has a specified maximum number of characters.
- [WriteDump()](functions/writedump.md) - Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.
- [WriteLog()](functions/writelog.md) - Writes a message to a log file.
- [WriteOutput()](functions/writeoutput.md) - Writes the given string to the main response buffer regardless of
conditions established by the cfsetting tag.
- [XmlChildPos()](functions/xmlchildpos.md) - Gets the position of a child element within an XML document object.
- [XmlElemNew()](functions/xmlelemnew.md) - Creates an XML document object element
- [XmlFormat()](functions/xmlformat.md) - Escapes special XML characters in a string, so that the
string is safe to use with XML.
- [XmlGetNodeType()](functions/xmlgetnodetype.md) - Determines the type of an XML document object node.
- [XmlNew()](functions/xmlnew.md) - Creates an XML document object.
- [XmlParse()](functions/xmlparse.md) - Converts an XML document that is represented as a string
variable into an XML document object.
- [XmlSearch()](functions/xmlsearch.md) - Uses an XPath language expression to search an XML document object.
- [XmlTransform()](functions/xmltransform.md) - Applies an Extensible Stylesheet Language Transformation (XSLT)
to an XML document object that is represented as a string
variable. An XSLT converts an XML document to another format
or representation by applying an Extensible Stylesheet
Language (XSL) stylesheet to it.
- [XmlValidate()](functions/xmlvalidate.md) - Uses a Document Type Definition (DTD) or XML Schema to validate an XML text document or an XML document object.
- [Year()](functions/year.md) - From a date/time object, gets the year value.
- [YesNoFormat()](functions/yesnoformat.md) - Yes, for a non-zero value; No, otherwise.