# Full list of System Properties and Enviromment Variables

# Environment Variables / System Properties for Lucee

This is an automatically generated list of Environment Variables and System Properties you can set for the Lucee Server, extracted directly from Lucee, see [GetSystemPropOrEnvVar()](functions/getsystemproporenvvar.md)

There is also [Environment Variables / System Properties for Lucee](../recipes/environment-variables-system-properties.md)

Each sub-heading is the name of the Environment Variable (EnvVar), the equivalent Java System Property (SysProp) is identical, simply in lower case, with underscores replaced by dots.

Refer to [Setting System Properties and Environment Variables](../recipes/setting-system-properties-and-env-vars.md) to learn how to configure these values






# Application

## LUCEE_APPLICATION_LISTENER

*SysProp:* `-Dlucee.application.listener`
*EnvVar:* `LUCEE_APPLICATION_LISTENER`

Which kind of Application Listener is supported? Possible values: `None` - no listener at all, `Classical` - Classic handling. Lucee looks for `Application.cfm` and `OnRequestEnd.cfm`, `Modern` - Modern handling. Lucee only looks for `Application.cfc`, `Mixed` - Mixed handling. Lucee looks for `Application.cfm`/`OnRequestEnd.cfm` as well as `Application.cfc`. This is an alias for lucee.listener.type

**Type:** string

## LUCEE_APPLICATION_MODE

*SysProp:* `-Dlucee.application.mode`
*EnvVar:* `LUCEE_APPLICATION_MODE`

Where/how does Lucee look for the Application Listener? Possible values: `currenttoroot`, `currentorroot`, `root`, `current`. This is an alias for lucee.listener.mode

**Type:** string

## LUCEE_DATETIMEFORMAT_MODE

*SysProp:* `-Dlucee.datetimeformat.mode`
*EnvVar:* `LUCEE_DATETIMEFORMAT_MODE`

Controls how datetimeFormat() interprets pattern masks such as WW and FF. `classic`: Emulates legacy formatting behavior (like Lucee 5), applying zero-padding and pattern length rules. `modern` (default): Uses Lucee 6+ behavior with precise pattern interpretation, aligned with Java's DateTimeFormatter for consistency and clarity. Use `classic` to maintain compatibility with legacy codebases that depend on padded output from formatting masks

**Type:** string | **Default:** modern | **Introduced:** 6.2.2.53

**Functions:** [DateTimeFormat()](functions/datetimeformat.md)

## LUCEE_DESERIALIZEJSON_ALLOWEMPTY

*SysProp:* `-Dlucee.deserializejson.allowempty`
*EnvVar:* `LUCEE_DESERIALIZEJSON_ALLOWEMPTY`

In Lucee 5, an empty string passed into the function deserializeJson will return an empty string back. In Lucee 6, this is no longer accepted and throws an exception. You can simulate the old behavior by setting this environment variable or SysProp to `true`. By setting the log level of the application log to `warn`, you will receive information in the log when the old behavior is used. This allows you to modify your code for the new behavior without encountering runtime issues with the existing code

**Type:** boolean | **Default:** false

**Functions:** [DeserializeJSON()](functions/deserializejson.md)

## LUCEE_IGNORE_SCOPES

*SysProp:* `-Dlucee.ignore.scopes`
*EnvVar:* `LUCEE_IGNORE_SCOPES`

Boolean value to ignore scopes when executing in specific contexts like JSR223 or CLI

**Type:** boolean | **Default:** false

## LUCEE_LISTENER_MODE

*SysProp:* `-Dlucee.listener.mode`
*EnvVar:* `LUCEE_LISTENER_MODE`

Where/how does Lucee look for the Application Listener? Possible values: `currenttoroot` - looks for the file `Application.cfc`/`Application.cfm` from the current up to the webroot directory, `currentorroot` - looks for the file `Application.cfc`/`Application.cfm` in the current directory and in the webroot directory, `root` - looks for the file `Application.cfc`/`Application.cfm` only in the webroot, `current` - looks for the file `Application.cfc`/`Application.cfm` only in the current template directory

**Type:** string | **Default:** current2root

## LUCEE_LISTENER_SINGLETON

*SysProp:* `-Dlucee.listener.singleton`
*EnvVar:* `LUCEE_LISTENER_SINGLETON`

Controls how Lucee manages Application.cfc instances (introduced in Lucee 7). When set to `false` (Classic behavior), Lucee creates a new Application.cfc instance for each request and executes the component body constructor every time. When set to `true` (Singleton behavior), the component loads only during startup or when the component template changes. Note: With singleton mode enabled, settings defined in the component body remain persistent between requests. Configuration changes should be made within listener functions like onApplicationStart, onSessionStart or onRequestStart

**Type:** boolean | **Default:** false | **Introduced:** 7.0.0.102

## LUCEE_LISTENER_TYPE

*SysProp:* `-Dlucee.listener.type`
*EnvVar:* `LUCEE_LISTENER_TYPE`

Which kind of Application Listener is supported? Possible values: `None` - no listener at all, `Classical` - Classic handling. Lucee looks for `Application.cfm` and `OnRequestEnd.cfm`, `Modern` - Modern handling. Lucee only looks for `Application.cfc`, `Mixed` - Mixed handling. Lucee looks for `Application.cfm`/`OnRequestEnd.cfm` as well as `Application.cfc`

**Type:** string

## LUCEE_MAPPING_FIRST

*SysProp:* `-Dlucee.mapping.first`
*EnvVar:* `LUCEE_MAPPING_FIRST`

Let's say you have the following code: `<cfinclude template="/foo/bar/index.cfm">` And you have the following mappings defined: `/foo/bar` and `/foo`. Then Lucee will look for `/index.cfm` in `/foo/bar` and for `/bar/index.cfm` in `/foo` and invoke the first `index.cfm` it finds, which could be in both mappings. If this setting is set to `true`, Lucee will only check `/foo/bar` for `index.cfm`

**Type:** boolean | **Default:** true

**Tags:** [<cfinclude>](tags/include.md) | **Functions:** [ExpandPath()](functions/expandpath.md)


# Charset

## LUCEE_RESOURCE_CHARSET

*SysProp:* `-Dlucee.resource.charset`
*EnvVar:* `LUCEE_RESOURCE_CHARSET`

Default character set for reading from/writing to various resources (files)

**Type:** string | **Default:** system charset

**Tags:** [<cffile>](tags/file.md), [<cfdirectory>](tags/directory.md) | **Functions:** [FileRead()](functions/fileread.md), [FileWrite()](functions/filewrite.md)

## LUCEE_TEMPLATE_CHARSET

*SysProp:* `-Dlucee.template.charset`
*EnvVar:* `LUCEE_TEMPLATE_CHARSET`

Default character set used to read templates (.cfm and .cfc files)

**Type:** string | **Default:** system charset

## LUCEE_WEB_CHARSET

*SysProp:* `-Dlucee.web.charset`
*EnvVar:* `LUCEE_WEB_CHARSET`

Default character set for output streams, form-, URL-, and CGI scope variables, and reading/writing the header

**Type:** string | **Default:** system charset


# Compiler

## LUCEE_CFML_WRITER

*SysProp:* `-Dlucee.cfml.writer`
*EnvVar:* `LUCEE_CFML_WRITER`

Specifies the CFML writer type (white-space or regular) for output buffering

**Type:** string

## LUCEE_ENABLE_DIALECT

*SysProp:* `-Dlucee.enable.dialect`
*EnvVar:* `LUCEE_ENABLE_DIALECT`

Boolean value to enable CFML dialect support

**Type:** boolean

## LUCEE_FULL_NULL_SUPPORT

*SysProp:* `-Dlucee.full.null.support`
*EnvVar:* `LUCEE_FULL_NULL_SUPPORT`

A boolean value to enable/disable full null support

**Type:** boolean | **Default:** false

## LUCEE_INSPECT_TEMPLATE

*SysProp:* `-Dlucee.inspect.template`
*EnvVar:* `LUCEE_INSPECT_TEMPLATE`

Controls how often Lucee checks to see if a template has changed

**Type:** string

## LUCEE_PRESERVE_CASE

*SysProp:* `-Dlucee.preserve.case`
*EnvVar:* `LUCEE_PRESERVE_CASE`

A boolean value. If `true`, Lucee will not convert variable names used in `dot notation` to UPPER CASE

**Type:** boolean

## LUCEE_SUPPRESS_WS_BEFORE_ARG

*SysProp:* `-Dlucee.suppress.ws.before.arg`
*EnvVar:* `LUCEE_SUPPRESS_WS_BEFORE_ARG`

A boolean value. If enabled, Lucee suppresses whitespace defined between the cffunction starting tag and the last cfargument tag. This setting is ignored when there is different output between these tags as whitespace

**Type:** boolean | **Default:** true

**Tags:** [<cffunction>](tags/function.md), [<cfargument>](tags/argument.md)

## LUCEE_TAG_POPULATE_LOCALSCOPE

*SysProp:* `-Dlucee.tag.populate.localscope`
*EnvVar:* `LUCEE_TAG_POPULATE_LOCALSCOPE`

Controls whether tags like cflock and cfquery populate their default result variables to local scope when inside a function. When `true`, variables go to local scope. When `false`, restores pre LDEV-5416 behavior where variables go to variables scope

**Type:** boolean | **Default:** true | **Introduced:** 7.0.1.13

**Tags:** [<cflock>](tags/lock.md), [<cfquery>](tags/query.md), [<cffile>](tags/file.md), [<cfthread>](tags/thread.md)

## LUCEE_TYPE_CHECKING

*SysProp:* `-Dlucee.type.checking`
*EnvVar:* `LUCEE_TYPE_CHECKING`

A boolean value. If enabled, Lucee enforces types defined in the code. If `false`, type definitions are ignored

**Type:** boolean | **Default:** true

## LUCEE_UDF_TYPE_CHECKING

*SysProp:* `-Dlucee.udf.type.checking`
*EnvVar:* `LUCEE_UDF_TYPE_CHECKING`

Alias for lucee.type.checking, enables or disables type checking for user-defined functions

**Type:** boolean

**Tags:** [<cffunction>](tags/function.md)


# Datasource

## LUCEE_DATASOURCE_MSSQL_MODERN

*SysProp:* `-Dlucee.datasource.mssql.modern`
*EnvVar:* `LUCEE_DATASOURCE_MSSQL_MODERN`

Boolean value to enable modern MSSQL datasource handling

**Type:** boolean | **Default:** false

**Tags:** [<cfquery>](tags/query.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)

## LUCEE_DATASOURCE_POOL_VALIDATE

*SysProp:* `-Dlucee.datasource.pool.validate`
*EnvVar:* `LUCEE_DATASOURCE_POOL_VALIDATE`

If enabled, Lucee will validate existing datasource connections reused from the datasource pool before using them. This protects from exceptions caused by connections dropped by the DB server but creates additional communication between Lucee and the DB server. Removed in 6.2

**Type:** boolean | **Deprecated:** 6.2

**Tags:** [<cfquery>](tags/query.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)


# Debugging

## LUCEE_CLI_PRINTEXCEPTIONS

*SysProp:* `-Dlucee.cli.printExceptions`
*EnvVar:* `LUCEE_CLI_PRINTEXCEPTIONS`

Print out exceptions within the CLI interface

**Type:** boolean | **Default:** false

## LUCEE_DEBUGGING_MAXPAGEPARTS

*SysProp:* `-Dlucee.debugging.maxPageParts`
*EnvVar:* `LUCEE_DEBUGGING_MAXPAGEPARTS`

Maximum number of debugging page parts (executionLogs to output), 0 to disable max limit

**Type:** numeric | **Default:** false

## LUCEE_DEBUGGING_OPTIONS

*SysProp:* `-Dlucee.debugging.options`
*EnvVar:* `LUCEE_DEBUGGING_OPTIONS`

Debug options, a comma-separated list of the following possible debug options to enable: `database`, `exception`, `template`, `dump`, `tracing`, `timer`, `implicit-access`, `query-usage`, `max-records-logged`

**Type:** string

## LUCEE_DUMP_THREADS

*SysProp:* `-Dlucee.dump.threads`
*EnvVar:* `LUCEE_DUMP_THREADS`

Used for debugging, when enabled, it will dump out running threads to the console via the background controller thread

**Type:** boolean

## LUCEE_FTP_DEBUG

*SysProp:* `-Dlucee.ftp.debug`
*EnvVar:* `LUCEE_FTP_DEBUG`

Boolean which enables debug logging to the console for FTP

**Type:** boolean | **Default:** false

**Tags:** [<cfftp>](tags/ftp.md)

## LUCEE_JSCH_DEBUG

*SysProp:* `-Dlucee.jsch.debug`
*EnvVar:* `LUCEE_JSCH_DEBUG`

Boolean which enables debug logging to the console for SFTP

**Type:** boolean | **Default:** false

**Tags:** [<cfftp>](tags/ftp.md)


# Deployment

## LUCEE_BASE_CONFIG

*SysProp:* `-Dlucee.base.config`
*EnvVar:* `LUCEE_BASE_CONFIG`

Specifies a path to an alternate location for your .CFConfig.json file

**Type:** string

## LUCEE_ENABLE_WARMUP

*SysProp:* `-Dlucee.enable.warmup`
*EnvVar:* `LUCEE_ENABLE_WARMUP`

Boolean to enable/disable Lucee warmup on start

**Type:** boolean

## LUCEE_TASK_DIRECTORY

*SysProp:* `-Dlucee.task.directory`
*EnvVar:* `LUCEE_TASK_DIRECTORY`

Specifies the directory where remote client task files are stored

**Type:** string

## LUCEE_VERSION

*SysProp:* `-Dlucee.version`
*EnvVar:* `LUCEE_VERSION`

Defines the version of Lucee to load. For example, setting it to 6.1.0.0 will load that version. If not available locally, Lucee will automatically download it from Maven

**Type:** string


# Extensions

## LUCEE_EXTENSIONS

*SysProp:* `-Dlucee.extensions`
*EnvVar:* `LUCEE_EXTENSIONS`

Defines a comma-separated list of Lucee extensions to install when starting up. The current list of installed extensions is available via the Lucee admin. This can be a simple list of IDs, then whatever the latest version(s) will be installed (SNAPSHOT or STABLE). It's recommended to always specify the exact version for consistent results

**Type:** string

## LUCEE_EXTENSIONS_INSTALL

*SysProp:* `-Dlucee.extensions.install`
*EnvVar:* `LUCEE_EXTENSIONS_INSTALL`

A boolean value to enable/disable the installation of extensions

**Type:** boolean | **Default:** true


# Library

## LUCEE_LIBRARY_ADDITIONAL_FUNCTION

*SysProp:* `-Dlucee.library.additional.function`
*EnvVar:* `LUCEE_LIBRARY_ADDITIONAL_FUNCTION`

Path to a directory for additional CFML-based functions Lucee should load to make these functions available in the application

**Type:** string

## LUCEE_LIBRARY_ADDITIONAL_TAG

*SysProp:* `-Dlucee.library.additional.tag`
*EnvVar:* `LUCEE_LIBRARY_ADDITIONAL_TAG`

Path to a directory for additional CFML-based tags Lucee should load as globally available tags following the custom tag interface

**Type:** string

## LUCEE_LIBRARY_DEFAULT_FLD

*SysProp:* `-Dlucee.library.default.fld`
*EnvVar:* `LUCEE_LIBRARY_DEFAULT_FLD`

Function Library Descriptor files (.fld) Lucee should load to make these functions available in the application

**Type:** string

## LUCEE_LIBRARY_DEFAULT_FUNCTION

*SysProp:* `-Dlucee.library.default.function`
*EnvVar:* `LUCEE_LIBRARY_DEFAULT_FUNCTION`

Path to a directory for CFML-based functions Lucee should load to make these functions available in the application

**Type:** string

## LUCEE_LIBRARY_DEFAULT_TAG

*SysProp:* `-Dlucee.library.default.tag`
*EnvVar:* `LUCEE_LIBRARY_DEFAULT_TAG`

Path to a directory for CFML-based tags Lucee should load as globally available tags following the custom tag interface

**Type:** string

## LUCEE_LIBRARY_DEFAULT_TLD

*SysProp:* `-Dlucee.library.default.tld`
*EnvVar:* `LUCEE_LIBRARY_DEFAULT_TLD`

Tag Library Descriptor files (.tld or .tldx) Lucee should load to make these tags available in the application

**Type:** string

## LUCEE_LIBRARY_FLD

*SysProp:* `-Dlucee.library.fld`
*EnvVar:* `LUCEE_LIBRARY_FLD`

Function Library Descriptor files (.fld) Lucee should load to make these functions available in the application

**Type:** string

## LUCEE_LIBRARY_FUNCTION

*SysProp:* `-Dlucee.library.function`
*EnvVar:* `LUCEE_LIBRARY_FUNCTION`

Path to a directory for CFML-based functions Lucee should load to make these functions available in the application

**Type:** string

## LUCEE_LIBRARY_TAG

*SysProp:* `-Dlucee.library.tag`
*EnvVar:* `LUCEE_LIBRARY_TAG`

Path to a directory for CFML-based tags Lucee should load as globally available tags following the custom tag interface

**Type:** string

## LUCEE_LIBRARY_TLD

*SysProp:* `-Dlucee.library.tld`
*EnvVar:* `LUCEE_LIBRARY_TLD`

Tag Library Descriptor files (.tld or .tldx) Lucee should load to make these tags available in the application

**Type:** string


# Logging

## LUCEE_CASCADING_WRITE_TO_VARIABLES_LOG

*SysProp:* `-Dlucee.cascading.write.to.variables.log`
*EnvVar:* `LUCEE_CASCADING_WRITE_TO_VARIABLES_LOG`

Enables logging when variables are implicitly written to the variables scope (without an explicit scope definition). When set to a log name (e.g., `application`), Lucee will log details about variables being assigned without explicit scope. The log level can be customized using the LUCEE_CASCADING_WRITE_TO_VARIABLES_LOGLEVEL setting. This helps identify code that could be optimized by using proper variable scoping. This setting excludes certain internal variables (`_cfquery`, `_cflock`, `_thread`) from being logged

**Type:** string | **Introduced:** 6.2.1.82

## LUCEE_CASCADING_WRITE_TO_VARIABLES_LOGLEVEL

*SysProp:* `-Dlucee.cascading.write.to.variables.loglevel`
*EnvVar:* `LUCEE_CASCADING_WRITE_TO_VARIABLES_LOGLEVEL`

Specifies the log level for cascading write detection logs. Valid values are: `DEBUG`, `INFO`, `WARN`, `ERROR`

**Type:** string | **Default:** DEBUG | **Introduced:** 6.2.1.82

## LUCEE_CFID_URL_LOG

*SysProp:* `-Dlucee.cfid.url.log`
*EnvVar:* `LUCEE_CFID_URL_LOG`

When set to a log name, Lucee will log all instances where CFID is read from a URL parameter and used. The log includes URL, IP address, user agent, referrer, and stack trace in JSON format. This helps identify code that needs to be updated before URL-based CFID is disabled for security reasons

**Type:** string | **Introduced:** 6.2.1.59

## LUCEE_CONTROLLER_LOG_THRESHOLD

*SysProp:* `-Dlucee.controller.log.threshold`
*EnvVar:* `LUCEE_CONTROLLER_LOG_THRESHOLD`

Enables logging when a step in the background controller thread exceeds a threshold in seconds. Set to 0 to disable. Entries are logged to the application.log file

**Type:** numeric | **Default:** true

## LUCEE_LOG_REFLECTION

*SysProp:* `-Dlucee.log.reflection`
*EnvVar:* `LUCEE_LOG_REFLECTION`

Boolean value to enable logging of Java reflection operations

**Type:** boolean | **Default:** false

## LUCEE_LOG_WEBCONTEXT

*SysProp:* `-Dlucee.log.webcontext`
*EnvVar:* `LUCEE_LOG_WEBCONTEXT`

A boolean value that enables web context identification in log entries when running in single mode. When enabled, log entries include web context labels (e.g., http://localhost:8886|engine) to distinguish which web context generated the log entry. Only active in single mode where all web contexts share the same log directory. In multi mode, this setting has no effect as each web context has its own log directory. Added in Lucee 6.2.2.63

**Type:** boolean | **Default:** true | **Introduced:** 6.2.2.63

## LUCEE_LOGGING_FORCE_APPENDER

*SysProp:* `-Dlucee.logging.force.appender`
*EnvVar:* `LUCEE_LOGGING_FORCE_APPENDER`

If set, override the default log4j appender, which is usually resource (log files), use console to log all logs to console

**Type:** string

## LUCEE_LOGGING_FORCE_LEVEL

*SysProp:* `-Dlucee.logging.force.level`
*EnvVar:* `LUCEE_LOGGING_FORCE_LEVEL`

If set, override the default log4j log level for all logs, which is usually ERROR

**Type:** string

## LUCEE_LOGGING_MAIN

*SysProp:* `-Dlucee.logging.main`
*EnvVar:* `LUCEE_LOGGING_MAIN`

Name of the main logger used by Lucee, for example, a non-existing logger is defined

**Type:** string

## LUCEE_SYSTEM_ERR

*SysProp:* `-Dlucee.system.err`
*EnvVar:* `LUCEE_SYSTEM_ERR`

Where is the error stream of the JVM sent? Possible values are: `null` (the stream is ignored), `class:<class-name>` - the data is sent to an instance of that class that must implement the java.io.PrintStream interface, `file:<file-path>` - an absolute path to a file name the stream is written to, `log` - stream is written to err.log in context/logs/

**Type:** string

## LUCEE_SYSTEM_OUT

*SysProp:* `-Dlucee.system.out`
*EnvVar:* `LUCEE_SYSTEM_OUT`

Where is the out stream of the JVM sent? Possible values are: `null` (the stream is ignored), `class:<class-name>` - the data is sent to an instance of that class that must implement the java.io.PrintStream interface, `file:<file-path>` - an absolute path to a file name the stream is written to, `log` - stream is written to out.log in context/logs/

**Type:** string

## STARTLOGDIRECTORY

*SysProp:* `-Dstartlogdirectory`
*EnvVar:* `STARTLOGDIRECTORY`

Directory for startup log files

**Type:** string


# Mail

## LUCEE_MAIL_USE_7BIT_TRANSFER_ENCODING_FOR_HTML_PARTS

*SysProp:* `-Dlucee.mail.use.7bit.transfer.encoding.for.html.parts`
*EnvVar:* `LUCEE_MAIL_USE_7BIT_TRANSFER_ENCODING_FOR_HTML_PARTS`

Enabled by default in Lucee 7

**Type:** boolean | **Default:** true

**Tags:** [<cfmail>](tags/mail.md), [<cfmailpart>](tags/mailpart.md)


# Osgi

## FELIX_LOG_LEVEL

*SysProp:* `-Dfelix.log.level`
*EnvVar:* `FELIX_LOG_LEVEL`

Log level for the Felix Framework (OSGi)

**Type:** string | **Default:** error

## LUCEE_ENABLE_BUNDLE_DOWNLOAD

*SysProp:* `-Dlucee.enable.bundle.download`
*EnvVar:* `LUCEE_ENABLE_BUNDLE_DOWNLOAD`

Controls whether Lucee is allowed to download OSGi bundles (JAR files). Valid values: `true` - Lucee can download required bundles if they're not available locally. `false` - Lucee will not download any OSGi bundles and will only use bundles that are already available locally. `always` - Forces Lucee to download bundles even if they are available locally. This is primarily useful for debugging purposes

**Type:** string | **Default:** true | **Introduced:** 5.3.5.11

## LUCEE_MAVEN_DEFAULT_REPOSITORIES

*SysProp:* `-Dlucee.maven.default.repositories`
*EnvVar:* `LUCEE_MAVEN_DEFAULT_REPOSITORIES`

Specifies a comma-separated list of Maven repository URLs to use before the default repositories (Maven Central, Sonatype, JCenter). This allows customizing the Maven repositories used by Lucee for downloading dependencies. URL must include a trailing /

**Type:** string

## LUCEE_MAVEN_LOCAL_REPOSITORY

*SysProp:* `-Dlucee.maven.local.repository`
*EnvVar:* `LUCEE_MAVEN_LOCAL_REPOSITORY`

Defines the location in the local filesystem where Lucee stores downloaded Maven artifacts. If not explicitly configured, artifacts will be stored in the default location at lucee-server/mvn/

**Type:** string

## LUCEE_MVN_REPO_RELEASES

*SysProp:* `-Dlucee.mvn.repo.releases`
*EnvVar:* `LUCEE_MVN_REPO_RELEASES`

Maven repository endpoint used by Lucee >= 6 to load release versions

**Type:** string | **Default:** https://oss.sonatype.org/service/local/repositories/releases/content/

## LUCEE_MVN_REPO_SNAPSHOTS

*SysProp:* `-Dlucee.mvn.repo.snapshots`
*EnvVar:* `LUCEE_MVN_REPO_SNAPSHOTS`

Maven repository endpoint used by Lucee >= 6 to load snapshot versions

**Type:** string | **Default:** https://oss.sonatype.org/content/repositories/snapshots/


# Performance

## LUCEE_ALLOW_COMPRESSION

*SysProp:* `-Dlucee.allow.compression`
*EnvVar:* `LUCEE_ALLOW_COMPRESSION`

Allows compressing (GZIP) the HTTP response if the client explicitly supports it

**Type:** boolean

## LUCEE_APPLICATION_PATH_CACHE_TIMEOUT

*SysProp:* `-Dlucee.application.path.cache.timeout`
*EnvVar:* `LUCEE_APPLICATION_PATH_CACHE_TIMEOUT`

Lucee caches the path information to the template; this defines the idle timeout for these cache elements in milliseconds

**Type:** timespan | **Default:** 20 seconds

## LUCEE_CACHE_VARIABLEKEYS

*SysProp:* `-Dlucee.cache.variableKeys`
*EnvVar:* `LUCEE_CACHE_VARIABLEKEYS`

Sets the max number of variable names (keys) to cache

**Type:** numeric | **Default:** true

## LUCEE_CONTROLLER_DISABLED

*SysProp:* `-Dlucee.controller.disabled`
*EnvVar:* `LUCEE_CONTROLLER_DISABLED`

Boolean value to disable the background controller thread that handles periodic tasks

**Type:** boolean | **Default:** false

## LUCEE_CONTROLLER_GC

*SysProp:* `-Dlucee.controller.gc`
*EnvVar:* `LUCEE_CONTROLLER_GC`

Controls whether Lucee runs System.GC() every 5 minutes. Previously Lucee always ran GC in the background controller. Available since 6.2

**Type:** boolean | **Default:** false | **Introduced:** 6.2

## LUCEE_PAGEPOOL_MAXSIZE

*SysProp:* `-Dlucee.pagePool.maxSize`
*EnvVar:* `LUCEE_PAGEPOOL_MAXSIZE`

Maximum size of the template pool (page pool) where Lucee holds loaded .cfm/.cfc files. No number smaller than 1000 is accepted

**Type:** numeric | **Default:** true

## LUCEE_PRECISE_MATH

*SysProp:* `-Dlucee.precise.math`
*EnvVar:* `LUCEE_PRECISE_MATH`

A boolean value. If enabled, this improves the accuracy of floating-point calculations but makes them slightly slower

**Type:** boolean | **Default:** false

## LUCEE_SCOPE_ARGUMENTS_CAPACITY

*SysProp:* `-Dlucee.scope.arguments.capacity`
*EnvVar:* `LUCEE_SCOPE_ARGUMENTS_CAPACITY`

Sets the initial capacity (size) for the arguments scope hashmap

**Type:** numeric | **Default:** true

## LUCEE_SCOPE_LOCAL_CAPACITY

*SysProp:* `-Dlucee.scope.local.capacity`
*EnvVar:* `LUCEE_SCOPE_LOCAL_CAPACITY`

Sets the initial capacity (size) for the local scope hashmap

**Type:** numeric | **Default:** true

## LUCEE_TASKS_LIMIT

*SysProp:* `-Dlucee.tasks.limit`
*EnvVar:* `LUCEE_TASKS_LIMIT`

Defines the maximum number of elements that can be stored in the cfthread scope. Once this limit is reached, the oldest entries are automatically removed to make room for new ones

**Type:** numeric | **Default:** true | **Introduced:** 6.0.2.10

**Tags:** [<cfthread>](tags/thread.md)

## LUCEE_THREADS_MAXDEFAULT

*SysProp:* `-Dlucee.threads.maxDefault`
*EnvVar:* `LUCEE_THREADS_MAXDEFAULT`

Sets the maximum number of parallel threads

**Type:** numeric | **Default:** true

**Tags:** [<cfthread>](tags/thread.md)


# Query

## LUCEE_CASCADE_TO_RESULTSET

*SysProp:* `-Dlucee.cascade.to.resultset`
*EnvVar:* `LUCEE_CASCADE_TO_RESULTSET`

When a variable has no scope defined (example: `#myVar#` instead of `#variables.myVar#`), Lucee will also search available resultsets (CFML Standard) or not

**Type:** boolean | **Default:** true

**Tags:** [<cfquery>](tags/query.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)

## LUCEE_QOQ_HSQLDB_DEBUG

*SysProp:* `-Dlucee.qoq.hsqldb.debug`
*EnvVar:* `LUCEE_QOQ_HSQLDB_DEBUG`

Boolean value to enable debug logging for HSQLDB Query of Queries operations

**Type:** boolean | **Default:** false

**Tags:** [<cfquery>](tags/query.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)

## LUCEE_QOQ_HSQLDB_DISABLE

*SysProp:* `-Dlucee.qoq.hsqldb.disable`
*EnvVar:* `LUCEE_QOQ_HSQLDB_DISABLE`

Boolean value to disable HSQLDB for Query of Queries, forcing use of alternative QoQ engine

**Type:** boolean | **Default:** false

**Tags:** [<cfquery>](tags/query.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)

## LUCEE_QOQ_PARALLELISM

*SysProp:* `-Dlucee.qoq.parallelism`
*EnvVar:* `LUCEE_QOQ_PARALLELISM`

Controls the parallelism level for Query of Queries operations

**Type:** numeric | **Default:** true

**Tags:** [<cfquery>](tags/query.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)

## LUCEE_QUERY_ALLOWEMPTYASNULL

*SysProp:* `-Dlucee.query.allowemptyasnull`
*EnvVar:* `LUCEE_QUERY_ALLOWEMPTYASNULL`

In Lucee 5, an empty string passed into a query parameter with a numeric type was interpreted as null. In Lucee 6, this is no longer accepted and throws an exception. You can simulate the old behavior by setting this environment variable or SysProp to `true`. By setting the log level of the datasource log to `warn`, you will receive information in the log when the old behavior is used. This allows you to modify your code for the new behavior without encountering runtime issues with the existing code

**Type:** boolean | **Default:** false

**Tags:** [<cfquery>](tags/query.md), [<cfqueryparam>](tags/queryparam.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)

## LUCEE_QUERY_RESULT_THRESHOLD

*SysProp:* `-Dlucee.query.result.threshold`
*EnvVar:* `LUCEE_QUERY_RESULT_THRESHOLD`

Enables automatic logging of database queries that return large result sets to help proactively identify potential OutOfMemory (OOM) issues. When set to a positive integer, Lucee will log a warning message to the datasource log category whenever a query returns a number of rows greater than or equal to the specified threshold. Set to 0 or leave unset to disable this feature (default behavior). Logs include execution time, row count, column count, threshold value, SQL query, and tag context. Helps identify problematic queries before they cause memory issues in production environments

**Type:** numeric | **Default:** false | **Introduced:** 6.2.3.15

**Tags:** [<cfquery>](tags/query.md) | **Functions:** [QueryExecute()](functions/queryexecute.md)


# Request

## LUCEE_ASYNC_REQUEST_HANDLE

*SysProp:* `-Dlucee.async.request.handle`
*EnvVar:* `LUCEE_ASYNC_REQUEST_HANDLE`

Boolean value to execute requests coming from the servlet engine in a separate thread or not

**Type:** boolean | **Default:** false

## LUCEE_QUEUE_ENABLE

*SysProp:* `-Dlucee.queue.enable`
*EnvVar:* `LUCEE_QUEUE_ENABLE`

Boolean value to enable or disable the Lucee request queue

**Type:** boolean | **Default:** false

## LUCEE_QUEUE_MAX

*SysProp:* `-Dlucee.queue.max`
*EnvVar:* `LUCEE_QUEUE_MAX`

The maximum concurrent requests that the engine allows to run at the same time before the engine begins to queue the requests

**Type:** numeric | **Default:** true

## LUCEE_QUEUE_TIMEOUT

*SysProp:* `-Dlucee.queue.timeout`
*EnvVar:* `LUCEE_QUEUE_TIMEOUT`

The time in milliseconds a request is held in the queue. If the time is reached, the request is rejected with an exception. If you set it to 0 seconds, the request timeout is used instead

**Type:** timespan | **Default:** false

## LUCEE_REQUEST_LIMIT_CONCURRENT_MAXNORMPRIO

*SysProp:* `-Dlucee.request.limit.concurrent.maxnormprio`
*EnvVar:* `LUCEE_REQUEST_LIMIT_CONCURRENT_MAXNORMPRIO`

Maximum number of normal priority concurrent requests

**Type:** numeric

## LUCEE_REQUEST_LIMIT_CONCURRENT_MAXNOSLEEP

*SysProp:* `-Dlucee.request.limit.concurrent.maxnosleep`
*EnvVar:* `LUCEE_REQUEST_LIMIT_CONCURRENT_MAXNOSLEEP`

The maximal number of threads that are allowed to be active on the server. If this is reached, requests get forced into a `nap` (defined by lucee.request.limit.concurrent.sleeptime)

**Type:** numeric

## LUCEE_REQUEST_LIMIT_CONCURRENT_SLEEPTIME

*SysProp:* `-Dlucee.request.limit.concurrent.sleeptime`
*EnvVar:* `LUCEE_REQUEST_LIMIT_CONCURRENT_SLEEPTIME`

How long a request should `nap` in milliseconds if it reaches the lucee.request.limit.concurrent.maxnosleep

**Type:** timespan

## LUCEE_REQUESTTIMEOUT

*SysProp:* `-Dlucee.requesttimeout`
*EnvVar:* `LUCEE_REQUESTTIMEOUT`

A boolean value. If `false`, Lucee will disable request timeouts

**Type:** boolean | **Default:** true

## LUCEE_REQUESTTIMEOUT_CONCURRENTREQUESTTHRESHOLD

*SysProp:* `-Dlucee.requesttimeout.concurrentrequestthreshold`
*EnvVar:* `LUCEE_REQUESTTIMEOUT_CONCURRENTREQUESTTHRESHOLD`

Concurrent request threshold to enforce a request timeout. If a request reaches the timeout, Lucee will only enforce it if this threshold is also reached. For example, setting it to 100 means the timeout is enforced only if there are at least 99 other requests running

**Type:** numeric

## LUCEE_REQUESTTIMEOUT_CPUTHRESHOLD

*SysProp:* `-Dlucee.requesttimeout.cputhreshold`
*EnvVar:* `LUCEE_REQUESTTIMEOUT_CPUTHRESHOLD`

A floating-point number between 0 and 1. CPU threshold to enforce a request timeout. If a request reaches the timeout, Lucee will only enforce it if the CPU usage of the current core is at least the specified threshold. For example, setting it to 0.5 enforces the timeout if the CPU is at least 50%

**Type:** numeric

## LUCEE_REQUESTTIMEOUT_MEMORYTHRESHOLD

*SysProp:* `-Dlucee.requesttimeout.memorythreshold`
*EnvVar:* `LUCEE_REQUESTTIMEOUT_MEMORYTHRESHOLD`

A floating-point number between 0 and 1. Memory threshold to enforce a request timeout. If a request reaches the request timeout, Lucee will only enforce that timeout if this threshold is also reached. For example, setting it to 0.5 enforces the timeout if the memory consumption of the server is at least 50%

**Type:** numeric

## LUCEE_STATUS_CODE

*SysProp:* `-Dlucee.status.code`
*EnvVar:* `LUCEE_STATUS_CODE`

A boolean value. If disabled, returns a 200 status code to the client even if an uncaught exception occurs

**Type:** boolean

## LUCEE_URL_ENCODEALLOWPLUS

*SysProp:* `-Dlucee.url.encodeAllowPlus`
*EnvVar:* `LUCEE_URL_ENCODEALLOWPLUS`

Enabled by default in Lucee 7, previously Lucee would attempt to re-encode a url param which contained a space. If the url param was already encoded, it would trigger re-encoding the param again, breaking it. This was avoidable previously by using cfhttp encodeurl=`false`, set to `false` to enable previous behaviour

**Type:** boolean | **Default:** true | **Introduced:** 6.2.0.171

**Tags:** [<cfhttp>](tags/http.md)


# Security

## LUCEE_ADMIN_ENABLED

*SysProp:* `-Dlucee.admin.enabled`
*EnvVar:* `LUCEE_ADMIN_ENABLED`

Should the Lucee Admin be available or not

**Type:** boolean | **Default:** true

## LUCEE_ADMIN_PASSWORD

*SysProp:* `-Dlucee.admin.password`
*EnvVar:* `LUCEE_ADMIN_PASSWORD`

Password used for the Lucee admin (when you run Lucee in multi mode, the password for the Server admin)

**Type:** string

## LUCEE_ALLOW_REFLECTION

*SysProp:* `-Dlucee.allow.reflection`
*EnvVar:* `LUCEE_ALLOW_REFLECTION`

Boolean value that enables Java reflection

**Type:** boolean | **Default:** true

## LUCEE_COMPILER_BLOCK_BYTECODE

*SysProp:* `-Dlucee.compiler.block.bytecode`
*EnvVar:* `LUCEE_COMPILER_BLOCK_BYTECODE`

Controls whether Lucee blocks the direct execution of precompiled bytecode files (.cfm). When `true`, only source code CFML files are allowed. Bytecode execution is blocked by default in Lucee 7 for security reasons

**Type:** boolean | **Default:** true | **Introduced:** 6.1.1.114

## LUCEE_DISABLE_SYSTEMPROXIES

*SysProp:* `-Dlucee.disable.systemProxies`
*EnvVar:* `LUCEE_DISABLE_SYSTEMPROXIES`

Boolean value to disable using system proxies for HTTP connections

**Type:** boolean | **Default:** false

**Tags:** [<cfhttp>](tags/http.md)

## LUCEE_ENCRYPTION_ALGORITHM

*SysProp:* `-Dlucee.encryption.algorithm`
*EnvVar:* `LUCEE_ENCRYPTION_ALGORITHM`

Default encryption algorithm used when none is specified. The default `cfmx_compat` is not cryptographically secure - strongly recommended to use `AES` instead. Valid values: `CFMX_COMPAT`, `AES`, `BLOWFISH`, `DES`

**Type:** string | **Default:** cfmx_compat

**Functions:** [Encrypt()](functions/encrypt.md), [Decrypt()](functions/decrypt.md)

## LUCEE_FILEUPLOAD_ALLOW_MIMETYPE_DETECTION

*SysProp:* `-Dlucee.fileupload.allow.mimetype.detection`
*EnvVar:* `LUCEE_FILEUPLOAD_ALLOW_MIMETYPE_DETECTION`

Boolean value that enables using Tika to detect the mime type for unknown file uploads

**Type:** boolean | **Default:** true | **Introduced:** 7.0.0.312

**Tags:** [<cffile>](tags/file.md) | **Functions:** [FileUpload()](functions/fileupload.md), [FileUploadAll()](functions/fileuploadall.md)

## LUCEE_ISDEFINED_LIMIT

*SysProp:* `-Dlucee.isdefined.limit`
*EnvVar:* `LUCEE_ISDEFINED_LIMIT`

Alias for lucee.security.limitEvaluation, limits variable evaluation in isDefined

**Type:** boolean

**Functions:** [IsDefined()](functions/isdefined.md)

## LUCEE_LOGINSTORAGE_ITERATIONS

*SysProp:* `-Dlucee.loginstorage.iterations`
*EnvVar:* `LUCEE_LOGINSTORAGE_ITERATIONS`

Specifies the number of encryption iterations for loginstorage

**Type:** numeric | **Default:** false

**Tags:** [<cflogin>](tags/login.md), [<cfloginuser>](tags/loginuser.md)

## LUCEE_LOGINSTORAGE_PRIVATEKEY

*SysProp:* `-Dlucee.loginstorage.privatekey`
*EnvVar:* `LUCEE_LOGINSTORAGE_PRIVATEKEY`

A private key used to encrypt loginstorage. If not defined, a simple base64 encoding is used

**Type:** string

**Tags:** [<cflogin>](tags/login.md), [<cfloginuser>](tags/loginuser.md)

## LUCEE_LOGINSTORAGE_SALT

*SysProp:* `-Dlucee.loginstorage.salt`
*EnvVar:* `LUCEE_LOGINSTORAGE_SALT`

The salt used for encrypting loginstorage. If no salt is defined, a hardcoded salt is used

**Type:** string

**Tags:** [<cflogin>](tags/login.md), [<cfloginuser>](tags/loginuser.md)

## LUCEE_PASSWORD_ENC_KEY

*SysProp:* `-Dlucee.password.enc.key`
*EnvVar:* `LUCEE_PASSWORD_ENC_KEY`

The private encryption key used by Lucee to encrypt passwords stored in the configuration, such as for datasources

**Type:** string

## LUCEE_SCRIPT_PROTECT

*SysProp:* `-Dlucee.script.protect`
*EnvVar:* `LUCEE_SCRIPT_PROTECT`

Script protect setting used by default. Consult the Lucee admin page /Settings/Request for details on possible settings

**Type:** string

## LUCEE_SECURITY_ISDEFINED

*SysProp:* `-Dlucee.security.isdefined`
*EnvVar:* `LUCEE_SECURITY_ISDEFINED`

Alias for lucee.security.limitEvaluation, limits variable evaluation in isDefined and related functions

**Type:** boolean

**Functions:** [IsDefined()](functions/isdefined.md)

## LUCEE_SECURITY_LIMITEVALUATION

*SysProp:* `-Dlucee.security.limitEvaluation`
*EnvVar:* `LUCEE_SECURITY_LIMITEVALUATION`

Disable evaluating expressions when accessing scopes, Lucee 7 defaults to enabling this setting for security reasons. A boolean value. If enabled, limits variable evaluation in functions/tags. If enabled, you cannot use expressions within [ ] like this: susi[getVariableName()]. This affects the following functions: IsDefined, structGet, structSort (when using pathToSubElement), empty and the following tags: savecontent attribute `variable`

**Type:** boolean | **Default:** false (Lucee 6), true (Lucee 7)

**Tags:** [<cfsavecontent>](tags/savecontent.md) | **Functions:** [IsDefined()](functions/isdefined.md), [StructGet()](functions/structget.md), [StructSort()](functions/structsort.md), [Empty()](functions/empty.md)

## LUCEE_SSL_CHECKSERVERIDENTITY

*SysProp:* `-Dlucee.ssl.checkserveridentity`
*EnvVar:* `LUCEE_SSL_CHECKSERVERIDENTITY`

A boolean value. If enabled, checks the identity of the SSL certificate with SMTP

**Type:** boolean | **Default:** true

**Tags:** [<cfmail>](tags/mail.md)

## LUCEE_UPLOAD_BLOCKLIST

*SysProp:* `-Dlucee.upload.blocklist`
*EnvVar:* `LUCEE_UPLOAD_BLOCKLIST`

Default block list for the tag cffile action=`upload`. A comma-separated list of extensions that are allowed when uploading files via forms

**Type:** string

**Tags:** [<cffile>](tags/file.md) | **Functions:** [FileUpload()](functions/fileupload.md), [FileUploadAll()](functions/fileuploadall.md)

## LUCEE_USE_LUCEE_SSL_TRUSTSTORE

*SysProp:* `-Dlucee.use.lucee.SSL.TrustStore`
*EnvVar:* `LUCEE_USE_LUCEE_SSL_TRUSTSTORE`

Specifies the file location of the trust store that contains trusted Certificate Authorities (CAs) for SSL/TLS connections in Java applications. Lucee 6 uses the JVM trust store by default

**Type:** string

**Tags:** [<cfhttp>](tags/http.md), [<cfmail>](tags/mail.md)

## LUCEE_XMLFEATURES_OVERRIDE_DISABLE

*SysProp:* `-Dlucee.xmlfeatures.override.disable`
*EnvVar:* `LUCEE_XMLFEATURES_OVERRIDE_DISABLE`

Boolean value to disable overriding XML parser features for security reasons

**Type:** boolean | **Default:** false

**Functions:** [XmlParse()](functions/xmlparse.md)


# Session

## LUCEE_CFID_URL_ALLOW

*SysProp:* `-Dlucee.cfid.url.allow`
*EnvVar:* `LUCEE_CFID_URL_ALLOW`

Controls whether Lucee accepts CFID values from URL query strings. Set to `false` to enhance security by requiring CFIDs to be passed via cookies only. Setting this to `false` is strongly recommended for all production environments. Replaces lucee.read.cfid.from.url in Lucee 6.2.1.59

**Type:** boolean | **Default:** true | **Introduced:** 6.2.1.59

## LUCEE_READ_CFID_FROM_URL

*SysProp:* `-Dlucee.read.cfid.from.url`
*EnvVar:* `LUCEE_READ_CFID_FROM_URL`

Controls whether Lucee accepts CFID values from URL query strings. Set to `false` to enhance security by requiring CFIDs to be passed via cookies only. Setting this to `false` is strongly recommended for all production environments. Replaced by lucee.cfid.url.allow in Lucee 6.2.1.59

**Type:** boolean | **Deprecated:** 6.2.1.59

## LUCEE_SESSIONCOOKIE_ROTATE_UNKNOWN

*SysProp:* `-Dlucee.sessionCookie.rotate.unknown`
*EnvVar:* `LUCEE_SESSIONCOOKIE_ROTATE_UNKNOWN`

Controls whether unknown CFML session cookies are automatically rotated. When `false`, unknown session cookies will not be rotated

**Type:** boolean | **Default:** true

**Functions:** [SessionRotate()](functions/sessionrotate.md)

## LUCEE_STORE_EMPTY

*SysProp:* `-Dlucee.store.empty`
*EnvVar:* `LUCEE_STORE_EMPTY`

A boolean value. If enabled, does not store empty sessions to the client or session storage

**Type:** boolean




# Categories

[Lucee Server related Tags, Functions and Guides](../categories/server.md)

# See Also

[GetSystemPropOrEnvVar()](functions/getsystemproporenvvar.md)