# Deprecated Tags & Functions

Backwards compatibility is considered super important in Lucee.

**Deprecated** means that whilst the functionality is still **supported** and **available**, Lucee offers newer, more modern way(s) to achieve the same result.

Why do we document something as deprecated? It's because there's newer functionality that offers:

- better argument order for functions, to make your code clearer
- better performance
- cleaner, clearer programming styles
- less overloaded functionality which results in complicated code signatures / documentation.

Realistically we seldom actually remove deprecated functionality from Lucee (eg [IsDefined()](functions/isdefined.md) still works in Lucee 5.x), but when something is deprecated, it's a warning that it might be removed, so you should act accordingly.

Deprecation also flags that the given feature **might** possibly be removed in a future **major** release of Lucee, therefore it acts as advice to stop using the functionality.

# Functions

- [CacheKeyExists()](functions/cachekeyexists.md) - this function is deprecated
- [CacheRegionExists()](functions/cacheregionexists.md) - this function exists solely for the purpose of compatibility with other CFML Engines.
- [CacheRegionNew()](functions/cacheregionnew.md) - This function exists solely for the purpose of compatibility with other CFML Engines.
- [CacheRegionRemove()](functions/cacheregionremove.md) - this function exists solely for the purpose of compatibility with other CFML Engines.
- [CacheRemoveAll()](functions/cacheremoveall.md) - this function is deprecated, use instead cacheClear. Removes all elements from the cache
- [ComponentInfo()](functions/componentinfo.md) - this function is deprecated, use function getMetadata instead.
- [CreateODBCDate()](functions/createodbcdate.md) - Creates an ODBC date object.
- [CreateODBCDateTime()](functions/createodbcdatetime.md) - Creates an ODBC date-time object.
- [DecrementValue()](functions/decrementvalue.md) - this function is deprecated, use instead the -- operator;Decrements the current number by one
- [Each()](functions/each.md) - call the given UDF/Closure with every entry (key/value) in the given collection.
- [Empty()](functions/empty.md) - This function is deprecated, use instead IsEmpty()
- [ESAPIEncode()](functions/esapiencode.md) - Encodes the given string for safe output to reduce the risk of Cross Site Scripting attacks.
- [GetCurrentContext()](functions/getcurrentcontext.md) - this function is deprecated, use function CallStackGet instead.
- [GetK2ServerDocCount()](functions/getk2serverdoccount.md) - This function is deprecated.
- [GetK2ServerDocCountLimit()](functions/getk2serverdoccountlimit.md) - This function is deprecated.
- [GetMetricData()](functions/getmetricdata.md) - Gets server performance metrics.
- [GetTemplatePath()](functions/gettemplatepath.md) - This function is deprecated.
Use the GetBaseTemplatePath() function instead.
- [ImageDrawImage()](functions/imagedrawimage.md) - this function is deprecated, use ImagePaste instead. Draws a image on a image with the baseline of the first character positioned at (x,y) in the image.
- [IncrementValue()](functions/incrementvalue.md) - this function is deprecated, use instead the ++ operator;Increments the current number by one
- [IsDefined()](functions/isdefined.md) - Evaluates a string value to determine whether the variable
named in it exists.
- [ListTrim()](functions/listtrim.md) - this function is deprecated, use instead ListCompact
- [LSEuroCurrencyFormat()](functions/lseurocurrencyformat.md) - this function is just an alias for lsCurrencyFormat
- [LSParseEuroCurrency()](functions/lsparseeurocurrency.md) - use function lsParseCurrency instead
- [NowServer()](functions/nowserver.md) - this function is deprecated, returns the current time on the server independent on lucee timezone definition
- [PagePoolClear()](functions/pagepoolclear.md) - Clear out all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool)
- [QueryConvertForGrid()](functions/queryconvertforgrid.md) - Use instead the function QuerySlice.
- [QueryGetRow()](functions/querygetrow.md) - this function is deprecated, use function QueryRowData instead.
- [QuotedValueList()](functions/quotedvaluelist.md) - Returns a quoted list of all the values, for a given column within the query, delimited by the value given.
this function is deprecated, use instead the function queryColumnData
- [s3deletebucket()](functions/s3deletebucket.md) - deletes a bucket, this function is deprecated, use instead S3Delete.
- [StoreAddACL()](functions/storeaddacl.md) - Adds ACL to existing ACL for object or bucket. This function operates identically to "S3AddACL", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreGetACL()](functions/storegetacl.md) - Returns an array of structures, with each structure representing an ACL (Access Control List) grant. This function operates identically to "S3GetACL", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreGetMetadata()](functions/storegetmetadata.md) - Returns the metadata related to the object or bucket. This function operates identically to "S3GetMetaData", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreSetACL()](functions/storesetacl.md) - Sets the ACL for object or bucket. This function operates identically to "S3SetACL", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [StoreSetMetadata()](functions/storesetmetadata.md) - Sets the metadata on bucket or object. This function operates identically to "S3SetMetaData", making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- [UnserializeJava()](functions/unserializejava.md) - literal definition of a serialized Java Object by function serialize
- [ValueArray()](functions/valuearray.md) - Returns an array of all the values, for a given column within the query.
this function is deprecated, use instead the function queryColumnData
- [ValueList()](functions/valuelist.md) - Returns a list of all the values, for a given column within the query, delimited by the value given.
this function is deprecated, use instead the function queryColumnData

# Tags

- [<cfauthenticate>](tags/authenticate.md) - Authenticates a user, setting a security context for the application.
For more information, see the descriptions of IsAuthenticated and AuthenticatedContext.
- [<cfservlet>](tags/servlet.md) - This tag has been deprecated and is non-functional.
- [<cfservletparam>](tags/servletparam.md) - This tag has been deprecated and is non-functional.