# Recommended Settings



## Recommended Settings

By default Lucee ships in compatible mode, so that most CFML applications will just work with developer friendly settings.

When deploying to production, Lucee should be locked down via configuration.

There are also a range of setting which are recommended for peak performance and security.

### Production

[Lucee Lockdown Guide](../guides/deploying-lucee-server-apps/securing-lucee-server-apps/lucee-lockdown-guide.md)

Error templates should be set to `error-public`, which only shows a generic error message, without revealing information about your code or server configuration.

```cfml
// .CFConfig.json or via the Admin, Settings - Error
{
  "errorGeneralTemplate": "/lucee/templates/error/error-public.cfm",
  "errorMissingTemplate": "/lucee/templates/error/error-public.cfm",
}
```

The Lucee Administrator should ideally be disabled, using the `LUCEE_ADMIN_ENABLED=false` see [Setting System Properties and Environment Variables](setting-system-properties-and-env-vars.md) or at a minimum locked down using webserver restrictions.

Debugging / Monitoring output templates should never be enabled on Production, see [Monitoring/Debugging](monitoring-debugging.md)

Ensure access to `.git` folders (or similar) are blocked via the websever configuration.

### Performance

Always use the Latest Stable Release and Java 21+ / Tomcat 11 or equivalent, older versions are slower.

Ideally, for fast and secure modern cfml applications, Scope Cascading should be disabled, as well as search result sets, see [Scopes](../guides/developing-with-lucee-server/scope.md)

```cfml
// Application.cfc or via the Admin, Settings - Scope
component {
   this.scopeCascading = "strict"; // default is standard
   this.searchResults = false; // default is true
}
```

For the best performance in production, "Inspect Templates" should be set to `never`, see [Supercharge your website](supercharge-your-website.md)

```cfml
// .CFConfig.json or via the Admin, Settings - Performance/Caching
{
  "inspectTemplate": "never"
}
```

### Security

Limit variable evaluation in functions/tags should be disabled.

```cfml
// Application.cfc or via the Admin Settings - Security
component {
   this.security.limitEvaluation=true; // default is false, before Lucee 7
}
```

Setting the env var `LUCEE_CFID_URL_ALLOW=false` to prevent sessions being loaded via urls.

# Categories

[Lucee Server related Tags, Functions and Guides](../categories/server.md)