# Query Listeners

**Introduced:** 6.0



# Query Listeners

Since Lucee 6.0, you can define a listener in the Application.cfc to listen to or manipulate every query executed.

## Global Listeners

This example shows how to define a global query listener in the Application.cfc:

```cfml
this.query.listener = {
    before: function (caller, args) {
        dump(label: "before", var: arguments);
    },
    after: function (caller, args, result, meta) {
        dump(label: "after", var: arguments);
    }
};
```

The listener can also be a component:

```cfml
this.query.listener = new QueryListener();
```

The component would look like this:

```cfml
component {
    function before(caller, args) {
        args.sql = "SELECT TABLE_NAME as abc FROM INFORMATION_SCHEMA.TABLES";
        args.maxrows = 2;
        return arguments;
    }

    function after(caller, args, result, meta) {
        var row = queryAddRow(result);
        result.setCell("abc", "123", row);
        return arguments;
    }

    function error(args, caller, meta, exception) {
        // Handle exception
    }
}
```

# Categories

[Queries](../categories/query.md)

# See Also

[<cfquery>](../reference/tags/query.md)