# Query Indexes

**Introduced:** 6.0



# Query Indexes

Since Lucee 6.0, you can set an index for a query result, which you can then use down the line.

## Setting an Index

This example shows how to define a query with an index:

```cfml
<cfquery name="qry" datasource="mysql" indexName="id">
    select 1 as id, 'Susi' as name
    union all
    select 2 as id, 'Peter' as name
</cfquery>
```

You can then access parts of the query like this:

```cfml
<cfdump var="#qry#">
<cfdump var="#QueryRowByIndex(qry, 2)#">
<cfdump var="#QueryRowDataByIndex(qry, 2)#">
<cfdump var="#QueryGetCellByIndex(qry, 'name', 2)#">
```

# Categories

[Queries](../categories/query.md)

# See Also

[QueryGetCellByIndex()](../reference/functions/querygetcellbyindex.md), [QueryRowByIndex()](../reference/functions/queryrowbyindex.md), [QueryRowDataByIndex()](../reference/functions/queryrowdatabyindex.md), [<cfquery>](../reference/tags/query.md)