# Query Async

**Introduced:** 6.0



# Query Async

Since Lucee 6.0, you can define that a query gets executed asynchronously. Asynchronous execution of queries is useful in many cases where you don’t want to wait for a query to be executed. You can now set a simple flag to enable this feature.

## Async Execution

This example shows how to define a query for async execution:

```cfml
query async=true {
~~~
update user set lastAccess=now()
~~~
}
```

But you may want to know when an exception is happening, so we use a local listener:

```cfml
query datasource="mysql" async=true listener={
    error: function (args, caller, meta, exception) {
        systemOutput(exception, true, true);
    }
} {
~~~
    update user set lastAccess=now()
~~~
}
```

## Other Option

Since Lucee 6.1, this can also be done with the help of "function listeners".

# Categories

[Queries](../categories/query.md)

# See Also

[<cfquery>](../reference/tags/query.md)