# Mail Listeners

**Introduced:** 6.0



# Mail Listeners

Since Lucee 6.0, you can define a listener in the Application.cfc to listen to or manipulate every mail executed.

### Global per Application.cfc Listeners

This example shows how to define a global mail listener in the Application.cfc:

```cfml
this.mail.listener = {
    before: function (caller, nextExecution, created, detail, closed, advanced, tries, id, type, remainingtries) {
        detail.from &= ".de";
        return arguments.detail;
    },
    after: function (caller, created, detail, closed, lastExecution, advanced, tries, id, type, passed, remainingtries) {
        systemOutput(arguments.keyList(), 1, 1);
    }
}
```

The listener can also be a component:

```cfml
this.mail.listener = new MailListener();
```

The component would look like this:

```cfml
component {
    function before(caller, nextExecution, created, detail, closed, advanced, tries, id, type, remainingtries) {
        detail.from &= ".de";
        return arguments.detail;
    }

    function after(caller, created, detail, closed, lastExecution, advanced, tries, id, type, passed, remainingtries) {
        systemOutput(arguments.keyList(), 1, 1);
    }
}
```

### Per tag Listeners

To add a Mail Listener to an individual [<cfmail>](../reference/tags/mail.md) tag (listeners defined in the listener attribute overwrites any mail listener defined in the [Application.cfc / <cfapplication>](../reference/tags/application.md):

```cfml
<cfset listener = new MailListener()>
<cfmail from="testlistener@testlucee.org" to="testlistener@testlucee.org" server="stmp.testlucee.org" port="25" 
	username="testlistener@testlucee.org" password="***********" subject="Test listener" listener="#listener#">
	test listener mail body
</cfmail>
```

### Dump of arguments to the Mail Listener before() method

<img alt="Mail Listener Before()" src="/assets/images/listeners/MailListener_before_arguments.png">

### Dump of arguments to the Mail Listener after() method (cfmail)

You can see the `from` and `to` mail IDs were changed in the arguments to the `after` function, the arguments struct contains the modified `from` and `to` keys from the `before` function.

<img alt="Mail Listener After()" src="/assets/images/listeners/MailListener_after_arguments.png">

# Categories

[Internet Protocols](../categories/protocols.md)

# See Also

[Sending Emails](mail-how-to-send-a-mail.md), [Application.cfc / <cfapplication>](../reference/tags/application.md), [<cfmail>](../reference/tags/mail.md)