# Inline Components

**Introduced:** 6.0



# Inline Components

Since Lucee 6.0, Lucee allows you to create inline components.

These are components you can create directly in your CFML code, with no need to create a `.cfc` file for it.

This feature allows you to directly use them, similar to closures, enabling more dynamic programming approaches.

This example shows how to create an inline component and then use it:

```run
<cfscript>
inline = new component {
    function subTest() {
        return "inline<br>";
    }
};
dump("inline->" & inline.subTest());
dump(inline);
</cfscript>
```

# Categories

[Components (CFCs)](../categories/component.md)

# See Also

[Sub Components](sub-components.md), [<cfcomponent>](../reference/tags/component.md)