# Encryption/Decryption with RSA public and private keys



# Encryption/Decryption

This document explains about Encryption/Decryption with public and private keys with simple examples.

Encryption/Decryption is a new functionality in Lucee 5.3. We have a new way to encrypt/decrypt string values. First we start with keys. In this case, there are two keys:

- Private key to encrypt
- Public key to decrypt

## Example 1:

```cfml
//index.cfm
directory action="list" directory=getDirectoryFromPath(getCurrentTemplatePath()) filter="example*.cfm" name="dir";
loop query=dir {
	echo('<a href="#dir.name#">#dir.name#</a><br>');
}
```

```cfml
key=generateRSAKeys();
dump(key)
```

This function generates RSA keys. Execute the example code above in the browser and a struct is returned containing the two keys: a private key and a public key. So, we can create these keys, and store them somewhere for later use.

## Example 2:

```cfml
key=generateRSAKeys();
raw="Hi, Hello !!!";
enc=encrypt(raw,key.private,"rsa");
dump(enc);
```

We now create RSA keys using the [GenerateRSAkeys()](../reference/functions/generatersakeys.md) function, and then use the key to encrypt using the [Encrypt()](../reference/functions/encrypt.md) function. The encrypt() function has some arguments. It has `key.private` which defines the key as the private key, and `rsa` indicates use of the RSA encryption algorithm. Then run the dump in the browser and we see the encrypted string for your input string.

## Example 3:

```cfml
key=generateRSAKeys();
raw="Hi, Hello !!!";
enc=encrypt(raw,key.private,"rsa");
dec=decrypt(enc,key.public,"rsa");
dump(dec);
```

This is a full detailed example of encrypt/decrypt functions. We create a key and we encrypt with the private key. Then we [Decrypt()](../reference/functions/decrypt.md) with the public key. Then run the dump in the browser and we see the original string returned as expected.

## Footnotes

Here you can see these details in the video also:

[Encryption/Decryption with public and private keys](https://www.youtube.com/watch?v=2fgfq-3nWfk)

# Categories

[Cryptography](../categories/crypto.md)

# See Also

[Decrypt()](../reference/functions/decrypt.md), [Encrypt()](../reference/functions/encrypt.md), [GenerateRSAkeys()](../reference/functions/generatersakeys.md)