# Console logging using SystemOutput



## Console Logging in Lucee

Most CFML developers are familiar with using [<cfdump>](../reference/tags/dump.md) when debugging.

Lucee has a very useful function [SystemOutput()](../reference/functions/systemoutput.md), which lets you write messages and dump objects to the console.

### What's the console?

If you are using Tomcat, you can run it interactively using `catalina run` in the `tomcat\bin` directory.

With [CommandBox](../guides/getting-started/commandbox.md), you can do similar, via `box server start --console`.

Both then run the Server with the console logs being output.

### What can we log?

Similar to [<cfdump>](../reference/tags/dump.md), [SystemOutput()](../reference/functions/systemoutput.md) can output both text and complex objects.

By default, it doesn't output new lines, the second boolean argument, `addNewLine` does what it says.

### Use with CI like GitHub Actions

When you are running tests remotely, any output from [SystemOutput()](../reference/functions/systemoutput.md) is then visible directly in the job log.

## Example

```cfml
<cfscript>
	array = [ 1, "array", now() ]
	systemOutput( array, true );
	struct = { lts: 5.4, stable: 6.2 };
	systemOutput( struct, true );
	query = queryNew( "id,name", "numeric,varchar", [ [ 1, "lucee" ], [ 2, "ralio" ] ] );
	systemOutput( query, true );
	systemOutput( "starting ftp <print-stack-trace>", true );
</cfscript>
```

Produces the following output in the console:

```bash
[1,"array",createDateTime(2025,8,14,17,9,0,242,"Europe/Berlin")]
{"STABLE":6.2,"LTS":5.4}
query("id":[1,2],"name":["lucee","ralio"])
starting ftp
java.lang.Exception: Stack trace
        at lucee.runtime.functions.other.SystemOutput.call(SystemOutput.java:62)
        at lucee.runtime.functions.other.SystemOutput.call(SystemOutput.java:42)
        at console_cfm$cf$1.call(/console.cfm:8)
        at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:1112)
        at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:1006)
```

# Categories

[Lucee Server related Tags, Functions and Guides](../categories/server.md)

# See Also

[SystemOutput()](../reference/functions/systemoutput.md), [WriteLog()](../reference/functions/writelog.md), [<cfdump>](../reference/tags/dump.md), [<cflog>](../reference/tags/log.md), [Troubleshooting Lucee Server problems](troubleshooting.md)